/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.functest.framework.util;

import com.meterware.httpunit.WebResponse;
import java.io.IOException;
import org.hamcrest.Description;
import org.hamcrest.TypeSafeMatcher;

public class ResponseMatchers {
    public static ResponseContainsString responseContains(String string) {
        return new ResponseContainsString(string);
    }

    public static ResponseCodeIs responseCodeIs(int code) {
        return new ResponseCodeIs(code);
    }

    public static class ResponseCodeIs
    extends TypeSafeMatcher<WebResponse> {
        private final int expectedResponseCode;

        public ResponseCodeIs(int expectedResponseCode) {
            this.expectedResponseCode = expectedResponseCode;
        }

        protected boolean matchesSafely(WebResponse item) {
            return item.getResponseCode() == this.expectedResponseCode;
        }

        public void describeTo(Description description) {
            description.appendText("WebResponse code should be ").appendValue((Object)this.expectedResponseCode);
        }
    }

    public static class ResponseContainsString
    extends TypeSafeMatcher<WebResponse> {
        private final String containedString;

        public ResponseContainsString(String containedString) {
            this.containedString = containedString;
        }

        protected boolean matchesSafely(WebResponse item) {
            try {
                return item.getText().contains(this.containedString);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }

        public void describeTo(Description description) {
            description.appendText("WebResponse text should contain ").appendValue((Object)this.containedString);
        }
    }
}

