/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.functest.framework.util;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.hamcrest.Description;
import org.hamcrest.TypeSafeMatcher;

public class RegexMatchers {
    public static RegexMatches regexMatches(String regex) {
        return new RegexMatches(regex);
    }

    public static RegexMatchesNot regexMatchesNot(String regex) {
        return new RegexMatchesNot(regex);
    }

    public static RegexMatchesPattern regexMatchesPattern(Pattern pattern) {
        return new RegexMatchesPattern(pattern);
    }

    public static RegexMatchesPatternNot regexMatchesPatternNot(Pattern pattern) {
        return new RegexMatchesPatternNot(pattern);
    }

    public static class RegexMatchesPatternNot
    extends TypeSafeMatcher<String> {
        private final Pattern pattern;

        public RegexMatchesPatternNot(Pattern pattern) {
            this.pattern = pattern;
        }

        protected boolean matchesSafely(String text) {
            Matcher match = this.pattern.matcher(text);
            return !this.pattern.matcher(text).find();
        }

        public void describeTo(Description description) {
            description.appendText("Text should not match regular expression ").appendValue((Object)this.pattern.pattern());
        }
    }

    public static class RegexMatchesPattern
    extends TypeSafeMatcher<String> {
        private final Pattern pattern;

        public RegexMatchesPattern(Pattern pattern) {
            this.pattern = pattern;
        }

        protected boolean matchesSafely(String text) {
            Matcher match = this.pattern.matcher(text);
            return this.pattern.matcher(text).find();
        }

        public void describeTo(Description description) {
            description.appendText("Text should match regular expression ").appendValue((Object)this.pattern.pattern());
        }
    }

    public static class RegexMatchesNot
    extends TypeSafeMatcher<String> {
        private final String regex;

        public RegexMatchesNot(String regex) {
            this.regex = regex;
        }

        protected boolean matchesSafely(String text) {
            Pattern pattern = Pattern.compile(this.regex, 8);
            Matcher match = pattern.matcher(text);
            return !match.find();
        }

        public void describeTo(Description description) {
            description.appendText("Text should not match regular expression ").appendValue((Object)this.regex);
        }
    }

    public static class RegexMatches
    extends TypeSafeMatcher<String> {
        private final String regex;

        public RegexMatches(String regex) {
            this.regex = regex;
        }

        protected boolean matchesSafely(String text) {
            Pattern pattern = Pattern.compile(this.regex, 8);
            Matcher match = pattern.matcher(text);
            return match.find();
        }

        public void describeTo(Description description) {
            description.appendText("Text should match regular expression ").appendValue((Object)this.regex);
        }
    }
}

