/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.functest.framework.upm;

import com.atlassian.event.api.EventPublisher;
import com.atlassian.fugue.Option;
import com.atlassian.httpclient.apache.httpcomponents.DefaultHttpClient;
import com.atlassian.httpclient.api.Request;
import com.atlassian.httpclient.api.Response;
import com.atlassian.httpclient.api.ResponsePromise;
import com.atlassian.httpclient.api.factory.HttpClientOptions;
import com.atlassian.httpclient.spi.ThreadLocalContextManagers;
import com.atlassian.integrationtesting.ApplicationPropertiesImpl;
import com.atlassian.jira.functest.framework.upm.DefaultCredentials;
import com.atlassian.jira.functest.framework.upm.PluginStatus;
import com.atlassian.sal.api.ApplicationProperties;
import com.atlassian.util.concurrent.Promise;
import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import java.net.URI;
import org.apache.http.Header;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.impl.auth.BasicScheme;
import org.apache.log4j.Logger;
import org.json.JSONException;
import org.json.JSONObject;

public class UpmRestClient {
    public static final String CONTENT_TYPE_PLUGIN_JSON = "application/vnd.atl.plugins.plugin+json";
    private final String baseUrl;
    private final UsernamePasswordCredentials credentials;
    private final DefaultHttpClient<Void> httpClient;
    private static final Logger log = Logger.getLogger(UpmRestClient.class);

    public UpmRestClient(String baseUrl, UsernamePasswordCredentials credentials) {
        this.baseUrl = (String)Preconditions.checkNotNull((Object)baseUrl, (Object)"baseurl");
        this.credentials = (UsernamePasswordCredentials)Preconditions.checkNotNull((Object)credentials, (Object)"credentials");
        this.httpClient = new DefaultHttpClient((EventPublisher)new VoidEventPublisher(), (ApplicationProperties)new ApplicationPropertiesImpl(baseUrl), ThreadLocalContextManagers.noop(), new HttpClientOptions());
    }

    public static UpmRestClient withDefaultAdminCredentials(String baseUrl) {
        return new UpmRestClient(baseUrl, DefaultCredentials.getDefaultAdminCredentials());
    }

    public boolean isPluginEnabled(String pluginKey) {
        return this.getPluginStatus(pluginKey).isEnabled();
    }

    public boolean isPluginUserInstalled(String pluginKey) {
        return this.getPluginStatus(pluginKey).isUserInstalled();
    }

    public PluginStatus getPluginStatus(String pluginKey) {
        try {
            return (PluginStatus)this.requestPluginStatus(pluginKey).get();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public Promise<PluginStatus> requestPluginStatus(final String pluginKey) {
        Preconditions.checkNotNull((Object)pluginKey, (Object)"pluginKey");
        return this.newRequest(this.upmPluginInformation(pluginKey)).get().transform().ok((Function)new Function<Response, PluginStatus>(){

            public PluginStatus apply(Response response) {
                String entity = response.getEntity();
                try {
                    JSONObject jsonObject = new JSONObject(entity);
                    boolean enabled = jsonObject.getBoolean("enabled");
                    boolean userInstalled = jsonObject.getBoolean("userInstalled");
                    return new PluginStatus(pluginKey, jsonObject, enabled, userInstalled);
                }
                catch (JSONException e) {
                    throw new RuntimeException("Requesting details of plugin with key \"" + pluginKey + "\" returned " + response.getStatusCode() + ": " + entity, e);
                }
            }
        }).notFound((Function)new Function<Response, PluginStatus>(){

            public PluginStatus apply(Response response) {
                throw new RuntimeException("Could not get details on plugin with key \"" + pluginKey + "\": plugin not installed (404).");
            }
        }).toPromise();
    }

    public Promise<Option<PluginStatus>> requestPluginStatusOption(final String pluginKey) {
        Preconditions.checkNotNull((Object)pluginKey, (Object)"pluginKey");
        return this.newRequest(this.upmPluginInformation(pluginKey)).get().transform().ok((Function)new Function<Response, Option<PluginStatus>>(){

            public Option<PluginStatus> apply(Response response) {
                String entity = response.getEntity();
                try {
                    JSONObject jsonObject = new JSONObject(entity);
                    boolean enabled = jsonObject.getBoolean("enabled");
                    boolean userInstalled = jsonObject.getBoolean("userInstalled");
                    return Option.some((Object)new PluginStatus(pluginKey, jsonObject, enabled, userInstalled));
                }
                catch (JSONException e) {
                    log.error((Object)("Got response " + response.getStatusCode() + ": " + entity));
                    throw new RuntimeException(e);
                }
            }
        }).notFound((Function)new Function<Response, Option<PluginStatus>>(){

            public Option<PluginStatus> apply(Response response) {
                return Option.none();
            }
        }).toPromise();
    }

    public ResponsePromise updatePlugin(String pluginKey, String json) {
        Preconditions.checkNotNull((Object)pluginKey, (Object)"pluginKey");
        try {
            return this.newRequest(this.upmPluginInformation(pluginKey)).setContentType(CONTENT_TYPE_PLUGIN_JSON).setEntity(json).put();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private Request newRequest(URI uri) {
        Header authenticateHeader = BasicScheme.authenticate((Credentials)this.credentials, (String)"UTF-8", (boolean)false);
        return this.httpClient.newRequest(uri).setHeader(authenticateHeader.getName(), authenticateHeader.getValue());
    }

    private URI upmPluginInformation(String pluginKey) {
        return URI.create(this.baseUrl + "/rest/plugins/1.0/" + pluginKey + "-key");
    }

    public void destroy() throws Exception {
        this.httpClient.destroy();
    }

    class VoidEventPublisher
    implements EventPublisher {
        VoidEventPublisher() {
        }

        public void publish(Object o) {
        }

        public void register(Object o) {
        }

        public void unregister(Object o) {
        }

        public void unregisterAll() {
        }
    }
}

