/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.functest.framework.suite;

import com.atlassian.jira.functest.framework.WebTestDescription;
import com.atlassian.jira.functest.framework.WebTestListener;
import com.atlassian.jira.functest.framework.suite.JUnit4WebTestDescription;
import com.atlassian.jira.functest.framework.suite.JUnit4WebTestListener;
import com.atlassian.jira.functest.framework.suite.WebTestSuite;
import com.atlassian.jira.util.Predicate;
import com.atlassian.jira.util.dbc.Assertions;
import com.atlassian.jira.webtests.util.ClassLocator;
import com.google.common.collect.Sets;
import java.lang.reflect.Modifier;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.junit.runner.Description;
import org.junit.runner.Runner;
import org.junit.runner.notification.RunListener;
import org.junit.runner.notification.RunNotifier;
import org.junit.runners.model.InitializationError;

public abstract class WebTestSuiteRunner
extends Runner {
    protected final Class<?> webTestSuiteClass;
    protected final WebTestSuite suite;
    protected final String testPackage;
    protected final Set<Class<?>> testClasses;

    public WebTestSuiteRunner(Class<?> webTestSuiteClass) throws InitializationError {
        this.webTestSuiteClass = Assertions.notNull("webTestSuiteClass", webTestSuiteClass);
        this.suite = this.instantiateSuite();
        this.testPackage = this.suite.webTestPackage();
        this.testClasses = this.filterClasses();
    }

    protected abstract Runner delegateRunner();

    protected Iterable<WebTestListener> listeners() {
        return Collections.emptyList();
    }

    private WebTestSuite instantiateSuite() {
        try {
            return (WebTestSuite)this.webTestSuiteClass.getConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (Exception e) {
            throw new RuntimeException("Unable to instantiate suite", e);
        }
    }

    private Set<Class<?>> filterClasses() {
        List<Class<Object>> webTests = new ClassLocator<Object>(Object.class).setAllowInner(true).setPredicate(new TestPredicate()).setPackage(this.testPackage).findClasses();
        return Sets.newLinkedHashSet(webTests);
    }

    public Description getDescription() {
        return this.delegateRunner().getDescription();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run(RunNotifier notifier) {
        Runner runner = this.delegateRunner();
        JUnit4WebTestDescription mainDescription = new JUnit4WebTestDescription(runner.getDescription());
        Iterable<WebTestListener> listeners = this.listeners();
        this.addListeners(notifier, listeners);
        try {
            this.fireSuiteStarted(listeners, mainDescription);
            runner.run(notifier);
        }
        finally {
            this.fireSuiteFinished(listeners, mainDescription);
        }
    }

    private void fireSuiteStarted(Iterable<WebTestListener> listeners, WebTestDescription suiteDescription) {
        for (WebTestListener listener : listeners) {
            listener.suiteStarted(suiteDescription);
        }
    }

    private void fireSuiteFinished(Iterable<WebTestListener> listeners, WebTestDescription suiteDescription) {
        for (WebTestListener listener : listeners) {
            listener.suiteFinished(suiteDescription);
        }
    }

    private void addListeners(RunNotifier notifier, Iterable<WebTestListener> listeners) {
        for (WebTestListener listener : listeners) {
            notifier.addListener((RunListener)new JUnit4WebTestListener(listener));
        }
    }

    public final WebTestSuite suite() {
        return this.suite;
    }

    private class TestPredicate
    implements Predicate<Class<?>> {
        private TestPredicate() {
        }

        @Override
        public boolean evaluate(Class<?> input) {
            return Modifier.isPublic(input.getModifiers()) && !Modifier.isAbstract(input.getModifiers());
        }
    }
}

