/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.functest.framework.suite;

import com.atlassian.jira.functest.framework.WebTestDescription;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import java.util.List;

public final class WebTestDescriptionList {
    private final List<WebTestDescription> descriptions;

    public WebTestDescriptionList(Iterable<WebTestDescription> descriptions) {
        this.descriptions = ImmutableList.copyOf(descriptions);
    }

    public WebTestDescriptionList(WebTestDescription ... descriptions) {
        this(Lists.newArrayList((Object[])descriptions));
    }

    public List<WebTestDescription> list() {
        return ImmutableList.copyOf(this.descriptions);
    }

    public List<WebTestDescription> singleTests() {
        return this.singleTests(this.descriptions);
    }

    private List<WebTestDescription> singleTests(Iterable<WebTestDescription> input) {
        ImmutableList.Builder builder = ImmutableList.builder();
        for (WebTestDescription description : input) {
            if (description.isTest()) {
                builder.add((Object)description);
                continue;
            }
            builder.addAll(this.singleTests(description.children()));
        }
        return builder.build();
    }
}

