/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.functest.framework.suite;

import com.atlassian.jira.util.dbc.Assertions;
import java.lang.reflect.Method;
import java.util.List;
import org.junit.runner.Description;
import org.junit.runner.notification.RunNotifier;
import org.junit.runners.ParentRunner;

public final class ParentRunnerHacker<T> {
    private final ParentRunner<T> runner;
    private final Method getChildren;
    private final Method describeChild;
    private final Method runChild;

    public ParentRunnerHacker(ParentRunner<T> runner) {
        this.runner = Assertions.notNull(runner);
        this.getChildren = this.findMethodImpl("getChildren", new Class[0]);
        this.describeChild = this.findMethodImpl("describeChild", Object.class);
        this.runChild = this.findMethodImpl("runChild", Object.class, RunNotifier.class);
        this.getChildren.setAccessible(true);
        this.describeChild.setAccessible(true);
        this.runChild.setAccessible(true);
    }

    private Method findMethodImpl(String name, Class<?> ... params) {
        Method answer = null;
        Class<?> runnerClass = this.runner.getClass();
        while (answer == null) {
            try {
                answer = runnerClass.getDeclaredMethod(name, params);
            }
            catch (NoSuchMethodException e) {
                if ((runnerClass = runnerClass.getSuperclass()) == ParentRunner.class) {
                    throw new AssertionError((Object)("went all the way from " + this.runner.getClass().getName() + " down to ParentRunner and could not find method " + name));
                }
            }
        }
        return answer;
    }

    public List<T> getChildren() {
        try {
            return (List)this.getChildren.invoke(this.runner, new Object[0]);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public Description describeChild(T child) {
        try {
            return (Description)this.describeChild.invoke(this.runner, child);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public void runChild(T child, RunNotifier notifier) {
        try {
            this.runChild.invoke(this.runner, child, notifier);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

