/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.functest.framework.suite;

import com.atlassian.jira.functest.framework.WebTestDescription;
import com.atlassian.jira.functest.framework.suite.Category;
import com.atlassian.jira.functest.framework.suite.WebTest;
import com.atlassian.jira.util.dbc.Assertions;
import com.google.common.base.Function;
import com.google.common.collect.Iterables;
import java.lang.annotation.Annotation;
import java.util.Arrays;
import java.util.Set;
import javax.annotation.Nullable;
import org.junit.runner.Description;

public class JUnit4WebTestDescription
implements WebTestDescription {
    public static Function<Description, WebTestDescription> TRANSFORMER = new Function<Description, WebTestDescription>(){

        public WebTestDescription apply(@Nullable Description input) {
            return new JUnit4WebTestDescription(input);
        }
    };
    private final Description description;
    private final Iterable<WebTestDescription> children;

    public JUnit4WebTestDescription(Description description) {
        this.description = Assertions.notNull(description);
        this.children = this.initChildren();
    }

    private Iterable<WebTestDescription> initChildren() {
        return Iterables.transform((Iterable)this.description.getChildren(), TRANSFORMER);
    }

    @Override
    public String name() {
        return this.description.getDisplayName();
    }

    @Override
    public String className() {
        return this.description.getClassName();
    }

    @Override
    public String methodName() {
        return this.description.getMethodName();
    }

    @Override
    public Class<?> testClass() {
        return this.description.getTestClass();
    }

    @Override
    public Iterable<Annotation> annotations() {
        return Arrays.asList(this.testClass().getAnnotations());
    }

    @Override
    public Set<Category> categories() {
        return Category.fromAnnotation(this.testClass().getAnnotation(WebTest.class));
    }

    @Override
    public boolean isTest() {
        return this.description.isTest();
    }

    @Override
    public boolean isSuite() {
        return this.description.isSuite();
    }

    @Override
    public int testCount() {
        return this.description.testCount();
    }

    @Override
    public Iterable<WebTestDescription> children() {
        return this.children;
    }

    public String toString() {
        return this.description.toString();
    }

    public boolean equals(Object obj) {
        if (!JUnit4WebTestDescription.class.isInstance(obj)) {
            return false;
        }
        JUnit4WebTestDescription that = (JUnit4WebTestDescription)obj;
        return this.description.equals((Object)that.description);
    }

    public int hashCode() {
        return this.description.hashCode();
    }
}

