/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.functest.framework.suite;

import com.atlassian.jira.functest.framework.suite.Category;
import com.atlassian.jira.functest.framework.suite.WebTest;
import java.util.Comparator;

public class FunctionalCategoryComparator
implements Comparator<Class<?>> {
    public static final FunctionalCategoryComparator INSTANCE = new FunctionalCategoryComparator();

    @Override
    public int compare(Class<?> test1, Class<?> test2) {
        Category category1 = this.getCategory(test1);
        Category category2 = this.getCategory(test2);
        if (category1 == null && category2 == null) {
            return this.compareByName(test1, test2);
        }
        if (category1 == null) {
            return 1;
        }
        if (category2 == null) {
            return -1;
        }
        int result = category1.compareTo(category2);
        return result != 0 ? result : this.compareByName(test1, test2);
    }

    private Category getCategory(Class<?> test1) {
        WebTest webTest = test1.getAnnotation(WebTest.class);
        if (webTest == null) {
            return null;
        }
        for (Category category : Category.fromAnnotation(webTest)) {
            if (!category.isFunctional()) continue;
            return category;
        }
        return null;
    }

    private int compareByName(Class<?> test1, Class<?> test2) {
        return test1.getSimpleName().compareTo(test2.getSimpleName());
    }
}

