/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.functest.framework.suite;

import com.atlassian.jira.functest.framework.suite.WebTest;
import com.atlassian.jira.util.dbc.Assertions;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.Set;

public enum Category {
    FUNC_TEST,
    SELENIUM_TEST,
    WEBDRIVER_TEST,
    TPM,
    PLATFORM_COMPATIBILITY,
    VISUAL_REGRESSION,
    VISUAL_REGRESSION_SETUP,
    QUNIT,
    DEV_MODE,
    REFERENCE_PLUGIN,
    IGNITE,
    PERFORMANCE,
    RELOADABLE_PLUGINS,
    DATABASE,
    IE_INCOMPATIBLE,
    INFRASTRUCTURE,
    ACTIVITY_STREAMS(true),
    ADMINISTRATION(true),
    API(true),
    APP_LINKS(true),
    ATTACHMENTS(true),
    BROWSE_PROJECT(true),
    BROWSING(true),
    BULK_OPERATIONS(true),
    CHARTING(true),
    CLONE_ISSUE(true),
    COMMENTS(true),
    COMPONENTS_AND_VERSIONS(true),
    CUSTOM_FIELDS(true),
    DASHBOARDS(true),
    EMAIL(true),
    FIELDS(true),
    FILTERS(true),
    GADGETS(true),
    HTTP(true),
    I18N(true),
    IMPORT_EXPORT(true),
    INDEXING(true),
    ISSUE_NAVIGATOR(true),
    ISSUES(true),
    ISSUE_LINKS(true),
    JELLY(true),
    JQL(true),
    LDAP(true),
    LICENSING(true),
    MOVE_ISSUE(true),
    PERMISSIONS(true),
    PLUGINS(true),
    PROJECT_IMPORT(true),
    PROJECTS(true),
    QUARTZ(true),
    REPORTS(true),
    RENAME_USER(true),
    REST(true),
    ROLES(true),
    SCHEMES(true),
    SECURITY(true),
    SETUP(true),
    SLOW_IMPORT(true),
    SUB_TASKS(true),
    TIME_TRACKING(true),
    TIME_ZONES(true),
    UPGRADE_TASKS(true),
    USERS_AND_GROUPS(true),
    WORKFLOW(true),
    WORKLOGS(true),
    CHANGE_HISTORY(true),
    ACTIVE_OBJECTS(true),
    ISSUE_TYPES(true),
    SCREENS(true),
    WELCOME_PLUGIN(true),
    ENTITY_PROPERTIES(true),
    SETUP_PRISTINE(true);

    private final boolean isFunctional;

    public static Category forString(String constName) {
        Assertions.notBlank("constName", constName);
        for (Category category : Category.values()) {
            if (!category.name().equalsIgnoreCase(constName)) continue;
            return category;
        }
        throw new IllegalArgumentException("No corresponding Category constant for value \"" + constName + "\"");
    }

    public static Set<Category> fromAnnotation(WebTest webTest) {
        if (webTest == null || webTest.value().length == 0) {
            return EnumSet.noneOf(Category.class);
        }
        return EnumSet.copyOf(Arrays.asList(webTest.value()));
    }

    private Category() {
        this(false);
    }

    private Category(boolean functional) {
        this.isFunctional = functional;
    }

    public boolean isFunctional() {
        return this.isFunctional;
    }
}

