/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.functest.framework.setup;

import com.atlassian.jira.functest.framework.FuncTestWebClientListener;
import com.atlassian.jira.functest.framework.util.text.MsgOfD;
import com.atlassian.jira.testkit.client.log.FuncTestOut;
import com.atlassian.jira.webtests.LicenseKeys;
import com.atlassian.jira.webtests.util.JIRAEnvironmentData;
import com.google.common.collect.Sets;
import com.meterware.httpunit.WebClientListener;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.NavigableSet;
import java.util.NoSuchElementException;
import junit.framework.Assert;
import net.sourceforge.jwebunit.WebTester;
import org.apache.commons.lang.StringUtils;

public class JiraSetupInstanceHelper {
    private static final String SYSTEM_TENANT_NAME = "_jiraSystemTenant";
    private final WebTester tester;
    private final JIRAEnvironmentData jiraEnvironmentData;

    public JiraSetupInstanceHelper(WebTester tester, JIRAEnvironmentData jiraEnvironmentData) {
        this.tester = tester;
        this.jiraEnvironmentData = jiraEnvironmentData;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public void ensureJIRAIsReadyToGo(FuncTestWebClientListener webClientListener) {
        FuncTestOut.log((Object)"Checking that JIRA is setup and ready to be tested...");
        if (!this.isJiraSetup(webClientListener)) {
            this.detectJohnson();
            Class<JiraSetupInstanceHelper> clazz = JiraSetupInstanceHelper.class;
            // MONITORENTER : com.atlassian.jira.functest.framework.setup.JiraSetupInstanceHelper.class
            this.setupJIRA();
            // MONITOREXIT : clazz
        }
        this.login("admin", "admin");
        FuncTestOut.log((Object)("JIRA is setup and 'admin' is logged in. " + new MsgOfD()));
    }

    public boolean isJiraSetup() {
        this.tester.beginAt("/");
        return this.hasBeenSetup();
    }

    private boolean isJiraSetup(FuncTestWebClientListener webClientListener) {
        this.tester.beginAt("/");
        this.tester.getDialog().getWebClient().addClientListener((WebClientListener)webClientListener);
        return this.hasBeenSetup();
    }

    private boolean hasBeenSetup() {
        String currentURL = this.tester.getDialog().getResponse().getURL().getPath();
        boolean hasBeenSetUp = (this.jiraEnvironmentData.getContext() + "/secure/Dashboard.jspa").equals(currentURL) || (this.jiraEnvironmentData.getContext() + "/login.jsp").equals(currentURL);
        return hasBeenSetUp;
    }

    private void detectJohnson() {
        String response = this.tester.getDialog().getResponseText();
        if (response.contains("JIRA Access Constraints")) {
            FuncTestOut.log((Object)("Test failed because we are getting the following johnson page:\n" + response));
            Assert.fail((String)"It appears that JIRA is currenty being Johnsoned.  That cant be good!");
        }
    }

    public void setupJIRAStepsInSet(EnumSet<SetupStage> stepsInRange) {
        try {
            for (SetupStage step : stepsInRange) {
                step.perform(this);
            }
        }
        catch (RuntimeException rte) {
            FuncTestOut.log((Object)("Unable to setup JIRA because of " + rte.getMessage()));
            throw rte;
        }
    }

    private void setupJIRA() {
        FuncTestOut.log((Object)"JIRA is not setup.  Installing a new V2 license and completing setup steps");
        try {
            this.setupJIRAStepsInSet(SetupStage.START.to(SetupStage.LICENSE.prev()));
            this.tester.assertTextPresent("the license key");
            SetupStage.LICENSE.perform(this);
            boolean step3Skipped = true;
            if (!this.tester.getDialog().isTextInResponse("Set Up Email Notifications")) {
                step3Skipped = false;
                this.tester.assertTextPresent("Set Up Administrator Account");
                SetupStage.ACCOUNT.perform(this);
            }
            this.tester.assertTextPresent("Set Up Email Notifications");
            SetupStage.EMAIL.perform(this);
            if (step3Skipped) {
                this.tester.assertTextPresent("JIRA is now ready to use, please log in and get started.");
            } else {
                this.tester.assertLinkPresent("header-details-user-fullname");
            }
        }
        catch (RuntimeException rte) {
            FuncTestOut.log((Object)("Unable to setup JIRA because of " + rte.getMessage()));
            throw rte;
        }
    }

    private boolean isDatabaseSetUp() {
        return !this.tester.getDialog().hasForm("jira-setup-database");
    }

    private void withHiddenFieldsTemporarilyEditable(Runnable runnable) {
        boolean isHiddenFieldsEditable = this.tester.getDialog().getWebClient().getClientProperties().isHiddenFieldsEditable();
        if (!isHiddenFieldsEditable) {
            this.tester.getDialog().getWebClient().getClientProperties().setHiddenFieldsEditable(true);
            runnable.run();
            this.tester.getDialog().getWebClient().getClientProperties().setHiddenFieldsEditable(isHiddenFieldsEditable);
        } else {
            runnable.run();
        }
    }

    private void selectBundle() {
        this.withHiddenFieldsTemporarilyEditable(new Runnable(){

            @Override
            public void run() {
                JiraSetupInstanceHelper.this.tester.setFormElement("selectedBundle", "TRACKING");
            }
        });
        this.tester.submit();
    }

    private void setupMode() {
        if (!this.tester.getDialog().isTextInResponse("Set Up Application Properties")) {
            this.withHiddenFieldsTemporarilyEditable(new Runnable(){

                @Override
                public void run() {
                    JiraSetupInstanceHelper.this.tester.setFormElement("setupOption", "classic");
                }
            });
            this.tester.submit();
        }
    }

    private void setupDatabase() {
        if (!this.tester.getDialog().isTextInResponse("Set Up Application Properties")) {
            if (StringUtils.isNotEmpty((String)this.jiraEnvironmentData.getProperty("databaseType"))) {
                FuncTestOut.log((Object)"Setting up external db");
                JiraSetupInstanceHelper.setupDirectJDBCConnection(this.tester, this.jiraEnvironmentData);
            } else {
                FuncTestOut.log((Object)"Setting up internal db");
                this.tester.checkCheckbox("databaseOption", "internal");
                this.tester.submit();
            }
        }
        Assert.assertTrue((String)this.tester.getDialog().getResponseText(), (boolean)this.tester.getDialog().getResponseText().contains("Set Up Application Properties"));
    }

    public static void setupDirectJDBCConnection(WebTester webTester, JIRAEnvironmentData environmentData) {
        webTester.checkCheckbox("databaseOption", "external");
        webTester.setFormElement("databaseType", environmentData.getProperty("databaseType"));
        webTester.setFormElement("jdbcHostname", environmentData.getProperty("db.host"));
        webTester.setFormElement("jdbcPort", environmentData.getProperty("db.port"));
        webTester.setFormElement("jdbcSid", environmentData.getProperty("db.instance"));
        webTester.setFormElement("jdbcDatabase", environmentData.getProperty("db.instance"));
        webTester.setFormElement("jdbcUsername", environmentData.getProperty("username"));
        webTester.setFormElement("jdbcPassword", environmentData.getProperty("password"));
        webTester.setFormElement("schemaName", environmentData.getProperty("schema-name"));
        webTester.submit();
    }

    private void setupJiraAdminAccount(String username, String password, String fullName, String email) {
        this.tester.setFormElement("username", username);
        this.tester.setFormElement("password", password);
        this.tester.setFormElement("confirm", password);
        this.tester.setFormElement("fullname", fullName);
        this.tester.setFormElement("email", email);
        this.tester.submit();
    }

    private void setupJiraEmailNotifications() {
        this.tester.submit("finish");
    }

    private void setupJiraApplicationProperties() {
        this.tester.setFormElement("title", "Your Company JIRA");
        this.tester.submit();
    }

    private void setupJiraUsingExistingLicense(LicenseKeys.License licenseKey, String buildType) {
        this.tester.checkRadioOption("licenseSetupSelector", "existingLicense");
        this.tester.setWorkingForm("setupLicenseForm");
        this.tester.setFormElement("setupLicenseKey", licenseKey.getLicenseString());
        this.tester.submit();
        this.tester.assertTextNotPresent("Invalid license type for this edition of JIRA. License should be of type " + buildType + ".");
    }

    private void login(String username, String password) {
        this.tester.beginAt("/login.jsp");
        this.tester.setFormElement("os_username", username);
        this.tester.setFormElement("os_password", password);
        this.tester.setWorkingForm("login-form");
        this.tester.submit();
    }

    private void logLicense(LicenseKeys.License licenseKey) {
        FuncTestOut.log((Object)("Using a '" + licenseKey.getDescription() + "' license which allows " + licenseKey.getMaxUsers() + " maximum users"));
    }

    public static enum SetupStage {
        START{

            @Override
            protected void perform(JiraSetupInstanceHelper helper) {
            }
        }
        ,
        MODE{

            @Override
            protected void perform(JiraSetupInstanceHelper helper) {
                helper.setupMode();
            }
        }
        ,
        DATABASE{

            @Override
            protected void perform(JiraSetupInstanceHelper helper) {
                if (!helper.isDatabaseSetUp()) {
                    helper.setupDatabase();
                }
            }
        }
        ,
        APPLICATION_PROPERTIES{

            @Override
            protected void perform(JiraSetupInstanceHelper helper) {
                helper.setupJiraApplicationProperties();
            }
        }
        ,
        BUNDLE{

            @Override
            protected void perform(JiraSetupInstanceHelper helper) {
                helper.selectBundle();
            }
        }
        ,
        LICENSE{

            @Override
            protected void perform(JiraSetupInstanceHelper helper) {
                helper.setupJiraUsingExistingLicense(LicenseKeys.V2_COMMERCIAL, "Enterprise");
            }
        }
        ,
        ACCOUNT{

            @Override
            protected void perform(JiraSetupInstanceHelper helper) {
                helper.setupJiraAdminAccount("admin", "admin", "Administrator", "admin@stuff.com.com");
            }
        }
        ,
        EMAIL{

            @Override
            protected void perform(JiraSetupInstanceHelper helper) {
                helper.setupJiraEmailNotifications();
            }
        }
        ,
        LOGIN{

            @Override
            protected void perform(JiraSetupInstanceHelper helper) {
                helper.login("admin", "admin");
            }
        }
        ,
        END{

            @Override
            protected void perform(JiraSetupInstanceHelper helper) {
            }
        };

        private static NavigableSet<SetupStage> NAVIGABLE_ENUMS;

        protected abstract void perform(JiraSetupInstanceHelper var1);

        public SetupStage next() {
            SetupStage nextOrNull = NAVIGABLE_ENUMS.higher(this);
            if (null == nextOrNull) {
                throw new NoSuchElementException("no next item for: " + (Object)((Object)this));
            }
            return nextOrNull;
        }

        public SetupStage prev() {
            SetupStage prevOrNull = NAVIGABLE_ENUMS.lower(this);
            if (null == prevOrNull) {
                throw new NoSuchElementException("no prev item for: " + (Object)((Object)this));
            }
            return prevOrNull;
        }

        public EnumSet<SetupStage> to(SetupStage endStage) {
            if (this.compareTo(endStage) > 0) {
                return EnumSet.noneOf(SetupStage.class);
            }
            return EnumSet.range(this, endStage);
        }

        static {
            NAVIGABLE_ENUMS = Sets.newTreeSet(Arrays.asList(SetupStage.values()));
        }
    }
}

