/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.functest.framework.security.xsrf;

import com.atlassian.jira.functest.framework.Form;
import com.atlassian.jira.functest.framework.FuncTestHelperFactory;
import com.atlassian.jira.functest.framework.Navigation;
import com.atlassian.jira.functest.framework.locator.CssLocator;
import com.atlassian.jira.functest.framework.locator.XPathLocator;
import com.atlassian.jira.testkit.client.log.FuncTestLogger;
import com.atlassian.jira.testkit.client.log.FuncTestLoggerImpl;
import com.atlassian.jira.util.dbc.Assertions;
import com.meterware.httpunit.WebForm;
import com.meterware.httpunit.WebLink;
import net.sourceforge.jwebunit.WebTester;
import org.junit.Assert;
import org.w3c.dom.Attr;
import org.w3c.dom.Node;

public class XsrfCheck {
    public static final String ATL_TOKEN = "atl_token";
    public static final String XSRF_DEFAULT_ERROR = "SecurityTokenMissing";
    private String description;
    private Setup setup;
    private Submission submission;
    private FuncTestHelperFactory funcTestHelperFactory;
    private FuncTestLogger logger;
    private boolean initCalled = false;

    public XsrfCheck(String description, Setup setup, Submission submission) {
        this.description = description;
        this.setup = setup;
        this.submission = submission;
        this.logger = new FuncTestLoggerImpl(2);
    }

    protected void init(FuncTestHelperFactory funcTestHelperFactory) {
        this.funcTestHelperFactory = funcTestHelperFactory;
        this.submission.init(funcTestHelperFactory);
        this.initCalled = true;
    }

    public void run() throws Exception {
        this.run(XSRF_DEFAULT_ERROR);
    }

    public void run(String xsrfError) throws Exception {
        if (!this.initCalled) {
            throw new IllegalStateException("init() must be called before running the check!");
        }
        this.logger.log((Object)("STARTING: " + this.description));
        this.logger.log((Object)"\t SETUP");
        this.getTester().gotoPage("");
        this.setup.setup();
        this.logger.log((Object)"\t SUBMITTING DODGY TOKEN");
        this.submission.removeToken();
        this.submission.submitRequest();
        this.getTester().assertTextPresent(xsrfError);
        this.logger.log((Object)"\t SETUP");
        this.getNavigation().gotoDashboard();
        this.setup.setup();
        this.logger.log((Object)"\t SUBMITTING VALID TOKEN");
        this.submission.submitRequest();
        this.getTester().assertTextNotPresent(xsrfError);
        this.logger.log((Object)("COMPLETED: " + this.description));
    }

    private WebTester getTester() {
        return this.funcTestHelperFactory.getTester();
    }

    private Navigation getNavigation() {
        return this.funcTestHelperFactory.getNavigation();
    }

    private Form getForm() {
        return this.funcTestHelperFactory.getForm();
    }

    public static String invalidTokenInUrl(String original) {
        int startIndex = original.indexOf(ATL_TOKEN);
        if (startIndex != -1) {
            StringBuilder sb = new StringBuilder(original);
            sb.insert(startIndex + ATL_TOKEN.length() + 1, "invalidToken");
            return sb.toString();
        }
        return original;
    }

    public static class CssLocatorLinkSubmission
    extends AbstractLinkSubmission {
        private final int index;
        private String cssExpression;
        private String originalUrl;

        public CssLocatorLinkSubmission(String cssExpression, int index) {
            this.cssExpression = cssExpression;
            this.index = index;
        }

        public CssLocatorLinkSubmission(String cssExpression) {
            this(cssExpression, 0);
        }

        @Override
        public String getLink() throws Exception {
            if (this.originalUrl == null) {
                CssLocator locator = new CssLocator(this.getTester(), this.cssExpression);
                Node[] nodes = locator.getNodes();
                if (this.index >= nodes.length) {
                    Assert.fail((String)String.format("Unable to find link %d at '%s'.", this.index, this.cssExpression));
                }
                this.originalUrl = ((Attr)nodes[this.index].getAttributes().getNamedItem("href")).getValue();
            }
            return this.originalUrl;
        }
    }

    public static class XPathLinkSubmission
    extends AbstractLinkSubmission {
        private String xPathExpression;
        private String originalUrl;

        public XPathLinkSubmission(String xPathExpression) {
            this.xPathExpression = xPathExpression;
        }

        @Override
        public String getLink() throws Exception {
            if (this.originalUrl == null) {
                XPathLocator locator = new XPathLocator(this.getTester(), this.xPathExpression);
                Node node = locator.getNode();
                Assertions.notNull("node not found for xPathExpression [" + this.xPathExpression + "]", node);
                this.originalUrl = ((Attr)node.getAttributes().getNamedItem("href")).getValue();
            }
            return this.originalUrl;
        }
    }

    public static class LinkWithTextSubmission
    extends AbstractLinkSubmission {
        private String linkText;
        private String originalUrl;

        public LinkWithTextSubmission(String linkText) {
            this.linkText = linkText;
        }

        @Override
        public String getLink() throws Exception {
            if (this.originalUrl == null) {
                WebLink link = this.getTester().getDialog().getResponse().getLinkWith(this.linkText);
                Assertions.notNull("link", link);
                this.originalUrl = link.getURLString();
            }
            return this.originalUrl;
        }
    }

    public static class LinkWithIdSubmission
    extends AbstractLinkSubmission {
        private String linkId;
        private String originalUrl;

        public LinkWithIdSubmission(String linkId) {
            this.linkId = linkId;
        }

        @Override
        public String getLink() throws Exception {
            if (this.originalUrl == null) {
                WebLink link = this.getTester().getDialog().getResponse().getLinkWithID(this.linkId);
                Assertions.notNull("link", link);
                this.originalUrl = link.getURLString();
            }
            return this.originalUrl;
        }
    }

    public static abstract class AbstractLinkSubmission
    extends BaseSubmission
    implements Submission {
        private String urlToSubmit;

        public abstract String getLink() throws Exception;

        @Override
        public void removeToken() throws Exception {
            this.urlToSubmit = XsrfCheck.invalidTokenInUrl(this.getLink());
        }

        @Override
        public void submitRequest() throws Exception {
            this.getTester().gotoPage(this.urlToSubmit);
            this.urlToSubmit = this.getLink();
        }
    }

    public static abstract class AsynchFormSubmission
    extends FormSubmission {
        private boolean removedTokenCalled;
        private final long timeoutMS;

        public AsynchFormSubmission(String submitId, long timeoutMS) {
            super(submitId);
            this.timeoutMS = timeoutMS;
            this.removedTokenCalled = false;
        }

        @Override
        public void removeToken() {
            this.removedTokenCalled = true;
            super.removeToken();
        }

        @Override
        public void submitRequest() {
            super.submitRequest();
            if (!this.removedTokenCalled) {
                boolean timedout = true;
                long then = System.currentTimeMillis();
                while (then - System.currentTimeMillis() < this.timeoutMS) {
                    this.sleep();
                    if (!this.isOperationFinished()) continue;
                    timedout = false;
                    break;
                }
                if (timedout) {
                    throw new RuntimeException("The Asynch Form Submission never became true");
                }
            }
            this.removedTokenCalled = false;
        }

        private void sleep() {
            try {
                Thread.sleep(250L);
            }
            catch (InterruptedException e) {
                throw new RuntimeException(e);
            }
        }

        public abstract boolean isOperationFinished();
    }

    public static class FormSubmissionWithId
    extends AbstractFormSubmission {
        private String submitId;

        public FormSubmissionWithId(String submitId) {
            this.submitId = submitId;
        }

        @Override
        public void submitRequest() {
            this.getTester().clickButton(this.submitId);
        }
    }

    public static class FormSubmission
    extends AbstractFormSubmission {
        private String submitName;

        public FormSubmission(String submitName) {
            this.submitName = submitName;
        }

        @Override
        public void submitRequest() {
            this.getTester().submit(this.submitName);
        }
    }

    public static abstract class AbstractFormSubmission
    extends BaseSubmission
    implements Submission {
        @Override
        public void removeToken() {
            for (WebForm webForm : this.getForm().getForms()) {
                if (webForm.hasParameterNamed(XsrfCheck.ATL_TOKEN)) {
                    webForm.getScriptableObject().setParameterValue(XsrfCheck.ATL_TOKEN, "invalidToken");
                }
                webForm.getScriptableObject().setAction(XsrfCheck.invalidTokenInUrl(webForm.getAction()));
            }
        }
    }

    static abstract class BaseSubmission
    implements Submission {
        protected FuncTestHelperFactory funcTestHelperFactory;

        BaseSubmission() {
        }

        @Override
        public void init(FuncTestHelperFactory funcTestHelperFactory) {
            this.funcTestHelperFactory = funcTestHelperFactory;
        }

        WebTester getTester() {
            return this.funcTestHelperFactory.getTester();
        }

        Navigation getNavigation() {
            return this.funcTestHelperFactory.getNavigation();
        }

        Form getForm() {
            return this.funcTestHelperFactory.getForm();
        }
    }

    public static interface Submission {
        public void init(FuncTestHelperFactory var1);

        public void removeToken() throws Exception;

        public void submitRequest() throws Exception;
    }

    public static interface Setup {
        public void setup();

        public static final class None
        implements Setup {
            @Override
            public void setup() {
            }
        }
    }
}

