/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.functest.framework.parser.filter;

import com.atlassian.jira.functest.framework.LocatorFactory;
import com.atlassian.jira.functest.framework.locator.CssLocator;
import com.atlassian.jira.functest.framework.parser.filter.FilterItem;
import com.atlassian.jira.util.dbc.Assertions;
import com.google.common.base.Function;
import com.google.common.collect.Lists;
import java.util.Arrays;
import java.util.List;
import javax.annotation.Nullable;
import org.w3c.dom.Node;

public class FilterTableParser {
    private final LocatorFactory locators;

    public FilterTableParser(LocatorFactory locators) {
        this.locators = locators;
    }

    public List<FilterItem> parse(String tableId) {
        return this.parse(this.locators.css("#" + tableId).getNode());
    }

    private List<FilterItem> parse(Node filterTableNode) {
        CssLocator cssLocator = this.locatorForFilterRows(filterTableNode);
        List<Node> filterNodes = Arrays.asList(cssLocator.getNodes());
        return Lists.transform(filterNodes, (Function)new Function<Node, FilterItem>(){

            public FilterItem apply(@Nullable Node filterNode) {
                return FilterTableParser.this.parseFilterItem(filterNode);
            }
        });
    }

    private FilterItem parseFilterItem(Node filterNode) {
        return new FilterItem.Builder().id(new ParseFilterId().apply(filterNode)).name(new ParseFilterName().apply(filterNode)).description(new ParseFilterDescription().apply(filterNode)).owner(new ParseFilterOwner().apply(filterNode)).build();
    }

    private CssLocator locatorForFilterRows(Node filterTableNode) {
        return new CssLocator(filterTableNode, "tbody tr");
    }

    private static class ParseFilterId
    implements Function<Node, Long> {
        private ParseFilterId() {
        }

        public Long apply(@Nullable Node filterRowNode) {
            Assertions.notNull("Can not retrieve a filter id from a ''null'' DOM Node", filterRowNode);
            return Long.valueOf(filterRowNode.getAttributes().getNamedItem("data-filter-id").getNodeValue());
        }
    }

    private static class ParseFilterOwner
    implements Function<Node, String> {
        static final String NO_OWNER_INFO = "";

        private ParseFilterOwner() {
        }

        public String apply(@Nullable Node input) {
            CssLocator filterDescriptionLocator = new CssLocator(input, "td [data-filter-field=owner-full-name]");
            if (filterDescriptionLocator.exists()) {
                return filterDescriptionLocator.getText();
            }
            return NO_OWNER_INFO;
        }
    }

    private static class ParseFilterDescription
    implements Function<Node, String> {
        public static final String EMPTY_DESCRIPTION = "";

        private ParseFilterDescription() {
        }

        public String apply(@Nullable Node input) {
            CssLocator filterDescriptionLocator = new CssLocator(input, "td [data-filter-field=description]");
            if (filterDescriptionLocator.exists()) {
                return filterDescriptionLocator.getText();
            }
            return EMPTY_DESCRIPTION;
        }
    }

    private static class ParseFilterName
    implements Function<Node, String> {
        private ParseFilterName() {
        }

        public String apply(@Nullable Node input) {
            return new CssLocator(input, "td [data-filter-field=name]").getText();
        }
    }
}

