/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.functest.framework.parser.filter;

import com.atlassian.jira.functest.framework.locator.TableLocator;
import com.atlassian.jira.functest.framework.locator.XPathLocator;
import com.atlassian.jira.functest.framework.parser.filter.FilterItem;
import com.atlassian.jira.functest.framework.parser.filter.WebTestSharePermission;
import com.google.common.collect.Lists;
import com.meterware.httpunit.TableCell;
import com.meterware.httpunit.WebLink;
import com.meterware.httpunit.WebTable;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import junit.framework.Assert;
import org.w3c.dom.Node;

public class FilterList {
    private static final String GLOBAL_PERM_STRING = "Shared with everyone";
    private static final Pattern GROUP_SHARE_REGEX = Pattern.compile("Group\\:\\s+(\\S*)");
    private static final Pattern ROLE_SHARE_REGEX = Pattern.compile("Project\\:\\s+(\\S*)\\s+Role\\:\\s+(\\S*)");
    private static final Pattern PROJECT_SHARE_REGEX = Pattern.compile("Project\\:\\s+(\\S*)");
    private String filterListName = null;
    private List<String> columns = Lists.newArrayList();
    private List<FilterItem> filterItems = null;

    public FilterList(TableLocator tableLocator) {
        WebTable table = tableLocator.getTable();
        if (table.getColumnCount() > 1) {
            for (int i = 0; i < table.getColumnCount(); ++i) {
                String cell = table.getCellAsText(0, i).trim();
                this.columns.add(cell);
            }
            this.filterItems = Lists.newArrayList();
            for (int j = 1; j < table.getRowCount(); ++j) {
                long id = 0L;
                String name = null;
                String description = null;
                String author = null;
                List<WebTestSharePermission> sharing = null;
                boolean isFav = false;
                long subscriptions = 0L;
                List<String> operations = null;
                long favCount = 0L;
                for (int i = 0; i < this.columns.size(); ++i) {
                    String col = this.columns.get(i);
                    TableCell cell = table.getTableCell(j, i);
                    if (col.equals("Name")) {
                        name = this.parseName(cell);
                        description = this.parseDescription(cell);
                        isFav = this.parseIsFav(cell);
                        id = this.parseId(cell);
                        continue;
                    }
                    if (col.equals("Owner")) {
                        author = this.parseAuthor(cell);
                        continue;
                    }
                    if (col.equals("Shared With")) {
                        sharing = this.parseSharing(tableLocator.getNode(), id);
                        continue;
                    }
                    if (col.equals("Subscriptions")) {
                        subscriptions = this.parseSubscriptions(cell);
                        continue;
                    }
                    if (col.equals("")) {
                        operations = this.parseOperations(cell);
                        continue;
                    }
                    if (!col.equals("Popularity")) continue;
                    favCount = this.parseFavCount(cell);
                }
                this.filterItems.add(new FilterItem(id, name, description, author, sharing, isFav, subscriptions, operations, favCount));
            }
        } else {
            this.filterListName = table.getCellAsText(0, 0);
        }
    }

    private List<WebTestSharePermission> parseSharing(Node tableNode, Long rowId) {
        String str = new XPathLocator(tableNode, "tbody/tr[contains(@id,'" + rowId + "')]//ul[@class='shareList']").getText();
        ArrayList list = Lists.newArrayList();
        int lastIndex = -1;
        int currentIndex = 0;
        while (lastIndex < currentIndex && currentIndex < str.length()) {
            String project;
            lastIndex = currentIndex;
            if (str.indexOf(GLOBAL_PERM_STRING, currentIndex) >= 0) {
                list.add(new WebTestSharePermission("global", null, null));
                currentIndex += GLOBAL_PERM_STRING.length();
                continue;
            }
            Matcher matcher = GROUP_SHARE_REGEX.matcher(str);
            boolean matched = false;
            if (matcher.find(currentIndex)) {
                String name = matcher.group(1);
                list.add(new WebTestSharePermission("group", name, null));
                currentIndex = matcher.end();
                matched = true;
            }
            matcher = ROLE_SHARE_REGEX.matcher(str);
            if (!matched && matcher.find(currentIndex)) {
                project = matcher.group(1);
                String role = matcher.group(2);
                list.add(new WebTestSharePermission("project", project, role));
                currentIndex = matcher.end();
                matched = true;
            }
            matcher = PROJECT_SHARE_REGEX.matcher(str);
            if (matched || !matcher.find(currentIndex)) continue;
            project = matcher.group(1);
            list.add(new WebTestSharePermission("project", project, null));
            currentIndex = matcher.end();
        }
        return list;
    }

    private Long parseId(TableCell cell) {
        if (cell.getLinks().length > 1) {
            return new Long(cell.getLinks()[1].getParameterValues("requestId")[0]);
        }
        WebLink webLink = cell.getLinks()[0];
        String id = webLink.getID();
        Assert.assertNotNull((String)("id must not be null + " + webLink), (Object)id);
        String idString = id.substring("filterlink_".length(), id.length());
        Assert.assertNotNull((Object)idString);
        Assert.assertFalse((String)("id must not equal null string: + " + id), (boolean)"null".equals(idString));
        return new Long(idString);
    }

    private Long parseFavCount(TableCell cell) {
        try {
            return new Long(cell.asText().trim());
        }
        catch (NumberFormatException e) {
            return new Long(cell.asText().trim().substring(0, 2).trim());
        }
    }

    private List<String> parseOperations(TableCell cell) {
        WebLink[] links;
        ArrayList result = Lists.newArrayList();
        for (WebLink link : links = cell.getLinks()) {
            String op = link.asText();
            op = op.trim();
            result.add(op);
        }
        return result;
    }

    private Long parseSubscriptions(TableCell cell) {
        if (cell.asText().indexOf("None") > 0) {
            return 0L;
        }
        return new Long(cell.getLinks()[0].asText().substring(0, cell.getLinks()[0].asText().indexOf(" ")));
    }

    private Boolean parseIsFav(TableCell cell) {
        return cell.getLinks()[0].getTitle() != null && cell.getLinks()[0].getTitle().contains("Remove this filter from your favourites");
    }

    private Long parseIssues(TableCell cell) {
        String issueCount = cell.getLinks().length == 0 ? cell.asText().trim() : cell.getLinks()[0].asText().trim();
        return new Long(issueCount);
    }

    private String parseAuthor(TableCell cell) {
        return cell.asText().trim();
    }

    private String parseDescription(TableCell cell) {
        if (cell.getLinks().length > 1) {
            return cell.asText().substring(cell.asText().lastIndexOf(cell.getLinks()[1].asText()) + cell.getLinks()[1].asText().length()).trim();
        }
        return cell.asText().substring(cell.asText().lastIndexOf(cell.getLinks()[0].asText()) + cell.getLinks()[0].asText().length()).trim();
    }

    private String parseName(TableCell cell) {
        if (cell.getLinks().length > 1) {
            return cell.getLinks()[1].asText().trim();
        }
        return cell.getLinks()[0].asText().trim();
    }

    public boolean containsColumn(String columnName) {
        return this.columns.contains(columnName);
    }

    public String getFilterListName() {
        return this.filterListName;
    }

    public List getColumns() {
        return this.columns;
    }

    public List<FilterItem> getFilterItems() {
        return this.filterItems;
    }

    public boolean isEmpty() {
        return this.filterItems == null || this.filterItems.isEmpty();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        FilterList that = (FilterList)o;
        if (this.columns != null ? !this.columns.equals(that.columns) : that.columns != null) {
            return false;
        }
        if (this.filterItems != null ? !this.filterItems.equals(that.filterItems) : that.filterItems != null) {
            return false;
        }
        return this.filterListName.equals(that.filterListName);
    }

    public int hashCode() {
        int result = this.filterListName.hashCode();
        result = 31 * result + (this.columns != null ? this.columns.hashCode() : 0);
        result = 31 * result + (this.filterItems != null ? this.filterItems.hashCode() : 0);
        return result;
    }
}

