/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.functest.framework.page;

import com.atlassian.jira.functest.framework.FuncTestHelperFactory;
import com.atlassian.jira.functest.framework.LocatorFactory;
import com.atlassian.jira.functest.framework.locator.IdLocator;
import java.util.ArrayList;
import java.util.List;
import net.sourceforge.jwebunit.WebTester;
import org.apache.commons.lang.StringUtils;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class ViewIssuePage {
    private final FuncTestHelperFactory funcTestHelperFactory;

    public ViewIssuePage(FuncTestHelperFactory funcTestHelperFactory) {
        this.funcTestHelperFactory = funcTestHelperFactory;
    }

    public String getAssignee() {
        return this.getFieldValue("assignee");
    }

    public String getAssigneeUsername() {
        return ViewIssuePage.getRelUsername(this.getFieldNode("assignee"));
    }

    public String getReporter() {
        return this.getFieldValue("reporter");
    }

    public String getReporterUsername() {
        return ViewIssuePage.getRelUsername(this.getFieldNode("reporter"));
    }

    public String getCreatorUserName() {
        String creatorAnchorId = "issuecreator_" + this.getIssueId();
        String creator = this.getLocatorFactory().id(creatorAnchorId).getText();
        if (creator.equals("")) {
            creator = ViewIssuePage.getRelUsername(this.getLocatorFactory().css("#issuecreateddetails-" + this.getIssueId()).getNode());
        }
        return creator;
    }

    public ViewIssuePage openTabWithId(String id) {
        if (id.equals(this.getActiveTabId())) {
            return this;
        }
        this.getTester().clickLink("changehistory-tabpanel");
        return new ViewIssuePage(this.funcTestHelperFactory);
    }

    public String getActiveTabId() {
        Element activeTab = (Element)this.getLocatorFactory().css("#issue-tabs li.active").getNode();
        return activeTab.getAttribute("id");
    }

    public String getIssueId() {
        String id = "";
        Node node = this.getLocatorFactory().id("key-val").getNode();
        if (node != null & node instanceof Element) {
            id = ((Element)node).getAttribute("rel");
        }
        return id;
    }

    public String getFieldValue(String fieldName) {
        String value = this.getLocatorFactory().id(fieldName + "-val").getText();
        return value == null ? null : value.trim();
    }

    public Node getFieldNode(String fieldName) {
        return this.getLocatorFactory().id(fieldName + "-val").getNode();
    }

    public static String getRelUsername(Node node) {
        List<String> usernames = ViewIssuePage.getRelUsernames(node);
        return usernames.size() == 1 ? usernames.get(0) : null;
    }

    public static List<String> getRelUsernames(Node node) {
        return ViewIssuePage.recurse(new ArrayList<String>(), node);
    }

    private static List<String> recurse(List<String> collector, Node node) {
        if (node instanceof Element) {
            String userName;
            Element element = (Element)node;
            if (element.hasAttribute("rel") && StringUtils.isNotBlank((String)(userName = element.getAttribute("rel").trim()))) {
                collector.add(userName);
            }
            NodeList kids = element.getChildNodes();
            for (int i = 0; i < kids.getLength(); ++i) {
                ViewIssuePage.recurse(collector, kids.item(i));
            }
        }
        return collector;
    }

    public String getCustomFieldValue(int customFieldId) {
        return this.getFieldValue("customfield_" + customFieldId);
    }

    public String getCustomFieldRelUsername(int customFieldId) {
        return ViewIssuePage.getRelUsername(this.getFieldNode("customfield_" + customFieldId));
    }

    public List<String> getCustomFieldRelUsernames(int customFieldId) {
        return ViewIssuePage.getRelUsernames(this.getFieldNode("customfield_" + customFieldId));
    }

    public boolean hasVoted() {
        String title = this.getLocatorFactory().id("vote-toggle").getText();
        if (title.equals("Remove vote for this issue")) {
            return true;
        }
        if (title.equals("Vote for this issue")) {
            return false;
        }
        throw new IllegalStateException("Unknown Vote title '" + title + "'");
    }

    public int getVoteCount() {
        return Integer.parseInt(this.getLocatorFactory().id("vote-data").getText());
    }

    public ViewIssuePage toggleVote() {
        this.getTester().clickLink("vote-toggle");
        return new ViewIssuePage(this.funcTestHelperFactory);
    }

    public boolean canVote() {
        return this.getLocatorFactory().id("vote-toggle").exists();
    }

    public boolean isWatching() {
        String title = this.getLocatorFactory().id("watching-toggle").getText();
        if (title.equals("Stop watching this issue")) {
            return true;
        }
        if (title.equals("Start watching this issue")) {
            return false;
        }
        throw new IllegalStateException("Unknown watch title '" + title + "'");
    }

    public int getWatcherCount() {
        return Integer.parseInt(this.getLocatorFactory().id("watcher-data").getText());
    }

    public ViewIssuePage toggleWatch() {
        this.getTester().clickLink("watching-toggle");
        return new ViewIssuePage(this.funcTestHelperFactory);
    }

    private LocatorFactory getLocatorFactory() {
        return this.funcTestHelperFactory.getLocator();
    }

    private WebTester getTester() {
        return this.funcTestHelperFactory.getTester();
    }

    public boolean containsEditButton() {
        IdLocator locator = this.getLocatorFactory().id("edit-issue");
        return locator.getNodes().length > 0;
    }
}

