/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.functest.framework.page;

import com.atlassian.core.util.StringUtils;
import com.atlassian.jira.functest.framework.page.AbstractWebTestPage;
import com.atlassian.jira.webtests.table.HtmlTable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class ManageWatchersPage
extends AbstractWebTestPage {
    @Override
    public String baseUrl() {
        return "ManageWatchers!default.jspa";
    }

    public List<String> getCurrentWatchers() {
        HtmlTable table = this.getTableWithId("watcher-list");
        ArrayList<String> watchers = new ArrayList<String>(table.getRowCount() - 1);
        for (HtmlTable.Row row : table.getRows()) {
            if (row.getRowIndex() <= 0) continue;
            watchers.add(row.getCellAsText(1));
        }
        return watchers;
    }

    public ManageWatchersPage addWatchers(String ... usernames) {
        this.getTester().setFormElement("userNames", this.concat(usernames));
        this.getTester().submit("add");
        ManageWatchersPage nextPage = new ManageWatchersPage();
        nextPage.setContext(this.funcTestHelperFactory);
        return nextPage;
    }

    private String concat(String[] usernames) {
        return StringUtils.createCommaSeperatedString(Arrays.asList(usernames));
    }
}

