/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.functest.framework.page;

import com.atlassian.jira.functest.framework.FuncTestHelperFactory;
import com.atlassian.jira.functest.framework.locator.CssLocator;
import com.atlassian.jira.webtests.table.HtmlTable;
import com.meterware.httpunit.WebTable;
import java.util.ArrayList;
import java.util.List;

public class IssueSearchPage {
    private final FuncTestHelperFactory funcTestHelperFactory;

    public IssueSearchPage(FuncTestHelperFactory funcTestHelperFactory) {
        this.funcTestHelperFactory = funcTestHelperFactory;
    }

    public boolean hasResultsTable() {
        return this.funcTestHelperFactory.getLocator().id("issuetable").exists();
    }

    public HtmlTable getResultsTable() {
        WebTable webTable = this.funcTestHelperFactory.getTester().getDialog().getWebTableBySummaryOrId("issuetable");
        return new HtmlTable(webTable);
    }

    public List<String> getResultsIssueKeys() {
        ArrayList<String> issueKeys = new ArrayList<String>();
        for (HtmlTable.Row row : this.getResultsTable().getRows()) {
            if (row.getRowIndex() <= 0) continue;
            issueKeys.add(row.getCellForHeading("Key"));
        }
        return issueKeys;
    }

    public String getWarning() {
        CssLocator warning = this.funcTestHelperFactory.getLocator().css("aui-message.warning");
        return warning.exists() ? warning.getText() : null;
    }
}

