/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.functest.framework.navigator;

import com.atlassian.jira.functest.framework.navigator.NavigatorCondition;
import com.meterware.httpunit.WebForm;
import junit.framework.Assert;
import net.sourceforge.jwebunit.WebTester;
import org.apache.commons.lang.StringUtils;
import org.jsoup.nodes.Document;

public class UserGroupPicker
implements NavigatorCondition {
    private static final String OPTION_EMPTY = "empty";
    private static final String OPTION_CURRENT_USER = "issue_current_user";
    private final String elementName;
    private String value;

    public UserGroupPicker(String elementName) {
        this(elementName, null);
    }

    public UserGroupPicker(String elementName, String value) {
        this.elementName = elementName;
        this.value = value;
    }

    public UserGroupPicker setCurrentUser() {
        return this.setValue(OPTION_CURRENT_USER);
    }

    public UserGroupPicker setAnyUser() {
        return this.setValue(null);
    }

    public UserGroupPicker setUser(String user) {
        return this.setValue("user:" + user);
    }

    public UserGroupPicker setGroup(String group) {
        return this.setValue("group:" + group);
    }

    public UserGroupPicker setEmpty() {
        return this.setValue(OPTION_EMPTY);
    }

    public UserGroupPicker setValue(String value) {
        this.value = value;
        return this;
    }

    @Override
    public void parseCondition(WebTester tester) {
        WebForm form = tester.getDialog().getForm();
        this.value = StringUtils.trimToNull((String)form.getParameterValue(this.elementName));
    }

    @Override
    public void assertSettings(Document document) {
        String value = document.getElementsByAttributeValue("name", this.elementName).get(0).val();
        value = StringUtils.trimToNull((String)value);
        Assert.assertEquals((String)("Value not set correctly for element: " + this.elementName), (String)this.value, (String)value);
    }

    @Override
    public NavigatorCondition copyCondition() {
        return new UserGroupPicker(this.elementName, this.value);
    }

    @Override
    public NavigatorCondition copyConditionForParse() {
        return new UserGroupPicker(this.elementName);
    }
}

