/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.functest.framework.navigator;

import com.atlassian.jira.functest.framework.navigator.NavigatorCondition;
import com.meterware.httpunit.WebForm;
import junit.framework.Assert;
import net.sourceforge.jwebunit.WebTester;
import org.apache.commons.lang.StringUtils;
import org.jsoup.nodes.Document;

public class QuerySearchCondition
implements NavigatorCondition {
    private static final String QUERY_ELEMENT = "summary";
    private String queryString = "";

    public QuerySearchCondition() {
        this("");
    }

    public QuerySearchCondition(String queryString) {
        this.setQueryString(queryString);
    }

    public QuerySearchCondition(QuerySearchCondition condition) {
        this(condition.queryString);
    }

    public void setQueryString(String queryString) {
        this.queryString = StringUtils.isBlank((String)queryString) ? "" : queryString;
    }

    @Override
    public void parseCondition(WebTester tester) {
        WebForm form = tester.getDialog().getForm();
        this.setQueryString(form.getParameterValue(QUERY_ELEMENT));
    }

    @Override
    public void assertSettings(Document document) {
        Assert.assertEquals((String)"Value not set correctly for element: summary", (String)this.queryString, (String)document.getElementsByAttributeValue("name", QUERY_ELEMENT).get(0).val());
    }

    @Override
    public NavigatorCondition copyCondition() {
        return new QuerySearchCondition(this);
    }

    @Override
    public NavigatorCondition copyConditionForParse() {
        return new QuerySearchCondition();
    }

    public String toString() {
        return "Query Search: '" + this.queryString;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        QuerySearchCondition that = (QuerySearchCondition)o;
        return !(this.queryString != null ? !this.queryString.equals(that.queryString) : that.queryString != null);
    }

    public int hashCode() {
        int result = this.queryString != null ? this.queryString.hashCode() : 0;
        return result;
    }

    private boolean parseBoolean(String bool) {
        return !StringUtils.isBlank((String)bool) && Boolean.valueOf(bool) != false;
    }
}

