/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.functest.framework.navigator;

import com.atlassian.jira.functest.framework.navigator.NavigatorCondition;
import com.meterware.httpunit.WebForm;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import net.sourceforge.jwebunit.WebTester;
import org.jsoup.Jsoup;
import org.jsoup.nodes.Document;
import org.jsoup.nodes.Element;
import org.jsoup.select.Elements;
import org.junit.Assert;

public abstract class MultiSelectCondition
implements NavigatorCondition {
    private List<String> options = new ArrayList<String>();
    private final String elementName;

    protected MultiSelectCondition(String elementName) {
        this.elementName = elementName;
    }

    protected MultiSelectCondition(String elementName, Collection<String> options) {
        this(elementName);
        this.addOptions(options);
    }

    protected MultiSelectCondition(MultiSelectCondition condition) {
        this(condition.elementName, condition.options);
    }

    public void setOptions(Collection<String> options) {
        this.options = options == null ? new ArrayList<String>() : new ArrayList<String>(options);
    }

    public boolean addOption(String option) {
        return option != null && this.options.add(option);
    }

    public boolean removeOption(String option) {
        return option != null && this.options.remove(option);
    }

    public void clearOptions() {
        this.options.clear();
    }

    public void addOptions(Collection<String> options) {
        if (options != null) {
            this.options.addAll(options);
        }
    }

    public void removeOptions(Collection<String> options) {
        if (options != null) {
            this.options.removeAll(options);
        }
    }

    public List<String> getOptions() {
        return this.options;
    }

    public String getElementName() {
        return this.elementName;
    }

    @Override
    public void parseCondition(WebTester tester) {
        WebForm form = tester.getDialog().getForm();
    }

    @Override
    public void assertSettings(Document document) {
        Document select = Jsoup.parse((String)document.getElementsByAttributeValue("name", this.elementName).html());
        Elements selected = select.getElementsByAttributeValue("selected", "selected");
        ArrayList<String> vals = new ArrayList<String>();
        for (Element element : selected) {
            vals.add(element.text().trim());
        }
        Assert.assertEquals((String)("Value not set correctly for element: " + this.elementName), this.options, vals);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MultiSelectCondition that = (MultiSelectCondition)o;
        if (this.elementName != null ? !this.elementName.equals(that.elementName) : that.elementName != null) {
            return false;
        }
        return !(this.options != null ? !this.options.equals(that.options) : that.options != null);
    }

    public int hashCode() {
        int result = this.options != null ? this.options.hashCode() : 0;
        result = 31 * result + (this.elementName != null ? this.elementName.hashCode() : 0);
        return result;
    }

    public String toString() {
        return "MultiSelectCondition{elementName='" + this.elementName + '\'' + ", options=" + this.options + '}';
    }
}

