/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.functest.framework.navigation.issue;

import com.google.common.base.Function;
import com.google.common.collect.Ordering;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.apache.commons.lang.builder.EqualsBuilder;
import org.apache.commons.lang.builder.HashCodeBuilder;
import org.apache.commons.lang.builder.ToStringBuilder;

public interface FileAttachmentsList {
    public List<FileAttachmentItem> get();

    public static class ZipFileAttachmentEntry {
        private String name;
        private String size;

        private ZipFileAttachmentEntry(String name, String size) {
            this.name = name;
            this.size = size;
        }

        public String getName() {
            return this.name;
        }

        public String getSize() {
            return this.size;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof ZipFileAttachmentEntry)) {
                return false;
            }
            ZipFileAttachmentEntry rhs = (ZipFileAttachmentEntry)obj;
            return new EqualsBuilder().append((Object)this.getName(), (Object)rhs.getName()).append((Object)this.getSize(), (Object)rhs.getSize()).isEquals();
        }

        public int hashCode() {
            return new HashCodeBuilder(17, 31).append((Object)this.name).append((Object)this.size).toHashCode();
        }

        public String toString() {
            return "[name=" + this.name + ",size=" + this.size + "]";
        }
    }

    public static class FileAttachmentItem {
        private long id;
        private String name;
        private String size;
        private String author;
        private String date;
        private List<ZipFileAttachmentEntry> zipEntries;

        FileAttachmentItem(long id, String name, String size, String author, String date, List<ZipFileAttachmentEntry> zipEntries) {
            this.id = id;
            this.name = name;
            this.size = size;
            this.author = author;
            this.date = date;
            this.zipEntries = zipEntries;
        }

        public long getId() {
            return this.id;
        }

        public String getName() {
            return this.name;
        }

        public String getSize() {
            return this.size;
        }

        public String getAuthor() {
            return this.author;
        }

        public String getDate() {
            return this.date;
        }

        public List<ZipFileAttachmentEntry> getZipEntries() {
            return Collections.unmodifiableList(this.zipEntries);
        }

        public FileAttachmentItem sortZipEntries(Ordering<ZipFileAttachmentEntry> order) {
            if (this.zipEntries != null) {
                this.zipEntries = order.immutableSortedCopy(this.zipEntries);
            }
            return this;
        }

        public boolean isZip() {
            return !this.zipEntries.isEmpty();
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof FileAttachmentItem)) {
                return false;
            }
            FileAttachmentItem rhs = (FileAttachmentItem)obj;
            return new EqualsBuilder().append((Object)this.date, (Object)rhs.date).append((Object)this.name, (Object)rhs.name).append((Object)this.size, (Object)rhs.size).append((Object)this.author, (Object)rhs.author).append(this.zipEntries, rhs.zipEntries).isEquals();
        }

        public int hashCode() {
            return new HashCodeBuilder(17, 31).append((Object)this.date).append((Object)this.name).append((Object)this.size).append((Object)this.author).append(this.zipEntries).toHashCode();
        }

        public String toString() {
            return new ToStringBuilder((Object)this).append("name", (Object)this.name).append("size", (Object)this.size).append("author", (Object)this.author).append("date", (Object)this.date).append("zipEntries", this.zipEntries).toString();
        }
    }

    public static class Items {
        public static final Ordering<ZipFileAttachmentEntry> ZIP_ENTRY_DEFUALT_ORDERING = Ordering.from((Comparator)String.CASE_INSENSITIVE_ORDER).onResultOf((Function)new Function<ZipFileAttachmentEntry, String>(){

            public String apply(ZipFileAttachmentEntry input) {
                return input.getName();
            }
        });

        public static ZipFileAttachmentEntry zipEntry(String name, String size) {
            return new ZipFileAttachmentEntry(name, size);
        }

        public static FileAttachmentItem zip(String name, String size, String author, String date, List<ZipFileAttachmentEntry> zipFileEntries) {
            return Items.zip(0L, name, size, author, date, zipFileEntries);
        }

        public static FileAttachmentItem zip(long id, String name, String size, String author, String date, List<ZipFileAttachmentEntry> zipFileEntries) {
            return new FileAttachmentItem(id, name, size, author, date, zipFileEntries);
        }

        public static FileAttachmentItem file(String name, String size, String author, String date) {
            return Items.file(0L, name, size, author, date);
        }

        public static FileAttachmentItem file(long id, String name, String size, String author, String date) {
            return new FileAttachmentItem(id, name, size, author, date, Collections.emptyList());
        }
    }
}

