/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.functest.framework.navigation;

import com.atlassian.jira.functest.framework.Navigation;
import com.atlassian.jira.functest.framework.NavigationImpl;
import com.atlassian.jira.functest.framework.navigation.AbstractBulkChangeWizard;
import com.atlassian.jira.functest.framework.navigation.BulkChangeWizard;
import com.atlassian.jira.webtests.util.JIRAEnvironmentData;
import net.sourceforge.jwebunit.WebTester;

public class BulkChangeWizardImpl
extends AbstractBulkChangeWizard {
    private final WebTester tester;
    private final Navigation navigation;

    public BulkChangeWizardImpl(WebTester tester, JIRAEnvironmentData environmentData) {
        this.tester = tester;
        this.navigation = new NavigationImpl(tester, environmentData);
    }

    @Override
    protected void clickOnNext() {
        this.navigation.clickOnNext();
    }

    @Override
    protected void clickOnConfirm() {
        this.tester.submit("Confirm");
    }

    @Override
    protected void selectAllIssueCheckboxes() {
        String[] paramNames;
        this.tester.setWorkingForm("bulkedit");
        for (String paramName : paramNames = this.tester.getDialog().getForm().getParameterNames()) {
            if (!paramName.startsWith("bulkedit_")) continue;
            this.tester.checkCheckbox(paramName);
        }
    }

    @Override
    protected void chooseOperationRadioButton(BulkChangeWizard.BulkOperations operation) {
        this.setTextElement("operation", operation.getRadioValue());
    }

    @Override
    protected void chooseCustomRadioButton(String radiogroupName, String radiobuttonValue) {
        this.setTextElement(radiogroupName, radiobuttonValue);
    }

    @Override
    protected void selectFirstTargetProject(String projectName) {
        this.navigation.issue().selectProject(projectName, "10000_1_pid");
    }

    @Override
    protected void selectIssueType(String issueType) {
        this.navigation.issue().selectIssueType(issueType, "10000_1_issuetype");
    }

    @Override
    protected void selectEachTargetProject(int numContextsToSelect, String projectName) {
        for (int i = 1; i <= numContextsToSelect; ++i) {
            this.navigation.issue().selectProject(projectName, String.format("10000_%d_pid", i));
        }
    }

    @Override
    protected void checkSameTargetForAllCheckbox() {
        this.tester.checkCheckbox("sameAsBulkEditBean", "10000_1_");
    }

    @Override
    protected void setTextElement(String fieldName, String value) {
        this.tester.setFormElement(fieldName, value);
    }

    @Override
    protected void setSelectElement(String fieldName, String value) {
        this.tester.setFormElement(fieldName, value);
    }

    @Override
    protected void checkCheckbox(String fieldName) {
        this.tester.checkCheckbox(fieldName);
    }

    @Override
    protected void checkCheckbox(String checkboxName, String value) {
        this.tester.checkCheckbox(checkboxName, value);
    }

    @Override
    protected boolean pageContainsText(String text) {
        return this.tester.getDialog().getResponseText().matches("(?s).*" + text.replace(" ", "\\s*") + ".*");
    }

    @Override
    protected void clickOnLinkId(String id) {
        this.tester.clickLink(id);
    }

    @Override
    protected void clickOnLinkWithText(String linkText) {
        this.tester.clickLinkWithText(linkText);
    }
}

