/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.functest.framework.navigation;

import java.util.EnumSet;

public interface BulkChangeWizard {
    public BulkChangeWizard selectAllIssues();

    public BulkChangeWizard chooseOperation(BulkOperations var1);

    public BulkChangeWizard chooseWorkflowTransition(BulkOperations var1);

    public BulkChangeWizard chooseTargetContextForAll(String var1);

    public BulkChangeWizard chooseTargetContextForAll(String var1, String var2);

    public BulkChangeWizard chooseTargetContextForEach(int var1, String var2);

    public BulkChangeWizard setFieldValue(String var1, String var2);

    public BulkChangeWizard setFieldValue(InputTypes var1, String var2, String var3);

    public BulkChangeWizard checkRetainForField(String var1);

    public BulkChangeWizard checkActionForField(String var1);

    public BulkChangeWizard finaliseFields();

    public BulkChangeWizard complete();

    public BulkChangeWizard revertTo(WizardState var1);

    public BulkChangeWizard cancel();

    public WizardState getState();

    public static enum InputTypes {
        TEXT,
        SELECT;

    }

    public static class BulkOperationsCustom
    implements BulkOperations {
        private final String radioValue;

        public BulkOperationsCustom(String radioValue) {
            this.radioValue = radioValue;
        }

        @Override
        public String getRadioValue() {
            return this.radioValue;
        }
    }

    public static enum BulkOperationsImpl implements BulkOperations
    {
        MOVE("bulk.move.operation.name"),
        EDIT("bulk.edit.operation.name"),
        TRANSITION("bulk.workflowtransition.operation.name"),
        DELETE("bulk.delete.operation.name");

        private final String radioValue;

        private BulkOperationsImpl(String radioValue) {
            this.radioValue = radioValue;
        }

        @Override
        public String getRadioValue() {
            return this.radioValue;
        }
    }

    public static interface BulkOperations {
        public String getRadioValue();
    }

    public static enum WizardState {
        SELECT_ISSUES(1, "Choose Issues"),
        CHOOSE_OPERATION(2, "Choose Operation"),
        CHOOSE_TARGET_CONTEXTS(3, "Operation Details"),
        SET_FIELDS(3, "Operation Details"),
        CONFIRMATION(4, "Confirmation"),
        COMPLETE(5, null);

        private final int stage;
        private final String linkText;

        public static EnumSet<WizardState> valuesWithLinks() {
            return EnumSet.complementOf(EnumSet.of(COMPLETE));
        }

        private WizardState(int stage, String linkText) {
            this.stage = stage;
            this.linkText = linkText;
        }

        public int getStage() {
            return this.stage;
        }

        public String getLinkText() {
            return this.linkText;
        }
    }
}

