/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.functest.framework.navigation;

import com.atlassian.jira.functest.framework.navigation.BulkChangeWizard;
import java.util.EnumSet;

public abstract class AbstractBulkChangeWizard
implements BulkChangeWizard {
    protected static final String SAME_FOR_ALL = "sameAsBulkEditBean";
    protected static final String BULK_EDIT_KEY = "10000_1_";
    protected static final String TARGET_PROJECT_ID = "10000_1_pid";
    protected static final String ISSUE_TYPE_SELECT = "10000_1_issuetype";
    protected static final String TARGET_PROJECT_ID_TEMPLATE = "10000_%d_pid";
    private BulkChangeWizard.WizardState state = BulkChangeWizard.WizardState.SELECT_ISSUES;
    private BulkChangeWizard.BulkOperations operation = null;

    @Override
    public BulkChangeWizard selectAllIssues() {
        this.validateState(BulkChangeWizard.WizardState.SELECT_ISSUES);
        this.selectAllIssueCheckboxes();
        this.clickOnNext();
        this.state = BulkChangeWizard.WizardState.CHOOSE_OPERATION;
        return this;
    }

    @Override
    public BulkChangeWizard chooseOperation(BulkChangeWizard.BulkOperations operation) {
        this.validateState(BulkChangeWizard.WizardState.CHOOSE_OPERATION);
        this.chooseOperationRadioButton(operation);
        this.clickOnNext();
        this.operation = operation;
        if (operation.getRadioValue().equals(BulkChangeWizard.BulkOperationsImpl.MOVE.getRadioValue())) {
            this.state = BulkChangeWizard.WizardState.CHOOSE_TARGET_CONTEXTS;
        } else if (operation.getRadioValue().equals(BulkChangeWizard.BulkOperationsImpl.EDIT.getRadioValue())) {
            this.state = BulkChangeWizard.WizardState.SET_FIELDS;
        } else if (operation.getRadioValue().equals(BulkChangeWizard.BulkOperationsImpl.DELETE.getRadioValue())) {
            this.state = BulkChangeWizard.WizardState.CONFIRMATION;
        }
        return this;
    }

    @Override
    public BulkChangeWizard chooseWorkflowTransition(BulkChangeWizard.BulkOperations workflowTransition) {
        this.validateState(BulkChangeWizard.WizardState.CHOOSE_OPERATION);
        this.chooseCustomRadioButton("wftransition", workflowTransition.getRadioValue());
        this.clickOnNext();
        this.operation = workflowTransition;
        return this;
    }

    @Override
    public BulkChangeWizard chooseTargetContextForAll(String projectName) {
        return this.chooseTargetContextForAll(projectName, null);
    }

    @Override
    public BulkChangeWizard chooseTargetContextForAll(String projectName, String issueType) {
        this.validateState(BulkChangeWizard.BulkOperationsImpl.MOVE, BulkChangeWizard.WizardState.CHOOSE_TARGET_CONTEXTS);
        this.checkSameTargetForAllCheckbox();
        this.selectFirstTargetProject(projectName);
        if (issueType != null && !issueType.isEmpty()) {
            this.selectIssueType(issueType);
        }
        this.clickOnNext();
        this.state = BulkChangeWizard.WizardState.SET_FIELDS;
        return this;
    }

    @Override
    public BulkChangeWizard chooseTargetContextForEach(int numContextsToSelect, String projectName) {
        this.validateState(BulkChangeWizard.BulkOperationsImpl.MOVE, BulkChangeWizard.WizardState.CHOOSE_TARGET_CONTEXTS);
        this.selectEachTargetProject(numContextsToSelect, projectName);
        this.clickOnNext();
        this.state = BulkChangeWizard.WizardState.SET_FIELDS;
        return this;
    }

    @Override
    public BulkChangeWizard setFieldValue(String fieldName, String value) {
        return this.setFieldValue(BulkChangeWizard.InputTypes.TEXT, fieldName, value);
    }

    @Override
    public BulkChangeWizard setFieldValue(BulkChangeWizard.InputTypes inputType, String fieldName, String value) {
        this.validateState(BulkChangeWizard.WizardState.SET_FIELDS);
        switch (inputType) {
            case SELECT: {
                this.setSelectElement(fieldName, value);
                break;
            }
            default: {
                this.setTextElement(fieldName, value);
            }
        }
        return this;
    }

    @Override
    public BulkChangeWizard checkRetainForField(String fieldName) {
        this.validateState(BulkChangeWizard.BulkOperationsImpl.MOVE, BulkChangeWizard.WizardState.SET_FIELDS);
        this.checkCheckbox("retain_" + fieldName);
        return this;
    }

    @Override
    public BulkChangeWizard checkActionForField(String fieldName) {
        this.validateState(BulkChangeWizard.BulkOperationsImpl.EDIT, BulkChangeWizard.WizardState.SET_FIELDS);
        this.checkCheckbox("actions", fieldName);
        return this;
    }

    @Override
    public BulkChangeWizard finaliseFields() {
        this.validateState(BulkChangeWizard.WizardState.SET_FIELDS);
        this.clickOnNext();
        if ((this.operation == BulkChangeWizard.BulkOperationsImpl.MOVE || this.operation == BulkChangeWizard.BulkOperationsImpl.EDIT) && this.pageContainsText("Step 4 of 4: Confirmation")) {
            this.state = BulkChangeWizard.WizardState.CONFIRMATION;
        }
        return this;
    }

    @Override
    public BulkChangeWizard complete() {
        this.validateState(BulkChangeWizard.WizardState.CONFIRMATION);
        if (this.operation == BulkChangeWizard.BulkOperationsImpl.MOVE) {
            this.clickOnNext();
        } else if (this.operation == BulkChangeWizard.BulkOperationsImpl.DELETE || this.operation == BulkChangeWizard.BulkOperationsImpl.EDIT) {
            this.clickOnConfirm();
        }
        this.state = BulkChangeWizard.WizardState.COMPLETE;
        return this;
    }

    @Override
    public BulkChangeWizard revertTo(BulkChangeWizard.WizardState state) {
        if (this.state.getStage() <= state.getStage()) {
            throw new IllegalStateException(String.format("Cannot revert from state: %s to state: %s: target state does not precede the current state.", new Object[]{this.state, state}));
        }
        switch (state) {
            case CHOOSE_TARGET_CONTEXTS: {
                if (this.operation.equals(BulkChangeWizard.BulkOperationsImpl.MOVE)) break;
                throw new IllegalStateException(this.illegalStateForOperation(state, this.operation));
            }
            case SET_FIELDS: {
                if (!EnumSet.of(BulkChangeWizard.BulkOperationsImpl.MOVE, BulkChangeWizard.BulkOperationsImpl.DELETE).contains(this.operation)) break;
                throw new IllegalStateException(this.illegalStateForOperation(state, this.operation));
            }
            case SELECT_ISSUES: 
            case CHOOSE_OPERATION: {
                this.operation = null;
                break;
            }
            case COMPLETE: 
            case CONFIRMATION: {
                throw new IllegalStateException(String.format("Cannot revert to state: %s.", new Object[]{state}));
            }
        }
        this.clickOnLinkWithText(state.getLinkText());
        this.state = state;
        return this;
    }

    @Override
    public BulkChangeWizard cancel() {
        this.clickOnLinkId("cancel");
        this.state = BulkChangeWizard.WizardState.COMPLETE;
        return this;
    }

    private String illegalStateForOperation(BulkChangeWizard.WizardState state, BulkChangeWizard.BulkOperations operation) {
        return String.format("Cannot revert to: %s: Operation %s does not this state.", new Object[]{state, operation});
    }

    protected abstract void clickOnNext();

    protected abstract void clickOnConfirm();

    protected abstract void clickOnLinkId(String var1);

    protected abstract void clickOnLinkWithText(String var1);

    protected abstract void selectAllIssueCheckboxes();

    protected abstract void chooseOperationRadioButton(BulkChangeWizard.BulkOperations var1);

    protected abstract void chooseCustomRadioButton(String var1, String var2);

    protected abstract void selectFirstTargetProject(String var1);

    protected abstract void selectIssueType(String var1);

    protected abstract void selectEachTargetProject(int var1, String var2);

    protected abstract void checkSameTargetForAllCheckbox();

    protected abstract void setTextElement(String var1, String var2);

    protected abstract void setSelectElement(String var1, String var2);

    protected abstract void checkCheckbox(String var1);

    protected abstract void checkCheckbox(String var1, String var2);

    protected abstract boolean pageContainsText(String var1);

    private void validateState(BulkChangeWizard.WizardState expectedState) {
        if (this.state != expectedState || this.state == BulkChangeWizard.WizardState.COMPLETE) {
            throw new IllegalStateException("Wizard is in invalid state. Expected state: " + (Object)((Object)expectedState) + "; actual state: " + this.state.toString());
        }
    }

    private void validateState(BulkChangeWizard.BulkOperations expectedOperation, BulkChangeWizard.WizardState expectedState) {
        if (this.operation != expectedOperation) {
            throw new IllegalStateException("Wizard is in invalid state. Expected operation: " + expectedOperation + "; actual operation: " + expectedOperation.toString());
        }
        this.validateState(expectedState);
    }

    @Override
    public BulkChangeWizard.WizardState getState() {
        return this.state;
    }
}

