/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.functest.framework.locator;

import com.atlassian.jira.functest.framework.jsoup.JSoupNode;
import com.atlassian.jira.functest.framework.jsoup.JSoupW3CEmitter;
import com.atlassian.jira.functest.framework.locator.AbstractLocator;
import com.atlassian.jira.functest.framework.locator.Locator;
import java.io.IOException;
import net.sourceforge.jwebunit.WebTester;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class CssLocator
extends AbstractLocator
implements Locator {
    private final boolean constructedViaTester;
    private final String cssSelector;
    private Node startNode;
    private JSoupW3CEmitter jSoupW3CEmitter;

    public CssLocator(WebTester tester, String cssSelector) {
        super(tester);
        if (cssSelector == null) {
            throw new IllegalArgumentException("The css selector must not be null");
        }
        this.cssSelector = cssSelector;
        this.constructedViaTester = true;
        this.startNode = null;
        this.checkStateOrInit();
    }

    public CssLocator(Node startNode, String cssSelector) {
        this.constructedViaTester = false;
        if (!(startNode instanceof JSoupNode)) {
            throw new IllegalArgumentException("You must provide a JSoupNode");
        }
        if (cssSelector == null) {
            throw new IllegalArgumentException("The css selector must not be null");
        }
        this.startNode = startNode;
        this.cssSelector = cssSelector;
        this.jSoupW3CEmitter = new JSoupW3CEmitter();
        this.checkStateOrInit();
    }

    private synchronized void checkStateOrInit() {
        if (this.nodes == null) {
            if (this.constructedViaTester) {
                this.originalWebResponse = this.getWebResponse(this.tester);
                try {
                    this.jSoupW3CEmitter = JSoupW3CEmitter.parse(this.originalWebResponse.getText());
                    this.startNode = this.jSoupW3CEmitter.getDocument();
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
            try {
                this.nodes = new Node[0];
                NodeList list = this.jSoupW3CEmitter.select(this.cssSelector, this.startNode);
                if (list.getLength() > 0) {
                    this.nodes = this.makeArr(list);
                }
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
    }

    @Override
    public Node[] getNodes() {
        this.checkStateOrInit();
        return this.nodes;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("CssLocator : ");
        sb.append(this.cssSelector);
        sb.append(" : ");
        sb.append(this.startNode);
        return this.toStringImpl(sb.toString());
    }

    private Node[] makeArr(NodeList nodeList) {
        Node[] nodes = new Node[nodeList.getLength()];
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Node node;
            nodes[i] = node = nodeList.item(i);
        }
        return nodes;
    }

    @Override
    protected Node betterNode(Node node) {
        return node;
    }
}

