/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.functest.framework.dump;

import com.atlassian.jira.functest.framework.dump.ArtifactDumper;
import com.atlassian.jira.testkit.client.log.FuncTestLogger;
import com.atlassian.jira.testkit.client.log.FuncTestLoggerImpl;
import com.meterware.httpunit.CurrentHttpInformation;
import java.util.Date;
import java.util.Map;
import junit.framework.TestCase;
import net.sourceforge.jwebunit.WebTester;

public class TestCaseDumpKit {
    public static void dumpTestInformation(TestCase testCase, Date when, Throwable thrownException) {
        TestCaseDumpKit.dumpTestInformation(testCase, when, thrownException, true);
    }

    public static void dumpTestInformation(TestCase testCase, Date when, Throwable thrownException, boolean dumpHtml) {
        TestCaseDumpKit.dumpTestInformation(testCase, when, thrownException, dumpHtml, ArtifactDumper.getTester(testCase));
    }

    public static void dumpTestInformation(TestCase testCase, Date when, Throwable thrownException, boolean dumpHtml, WebTester tester) {
        FuncTestLoggerImpl log = new FuncTestLoggerImpl();
        log.log((Object)"\n______ TEST FAILURE ______ \n");
        String responseText = null;
        if (tester == null || tester.getDialog() == null) {
            log.log((Object)"The WebTester does not have a dialog associated with it?");
        } else {
            responseText = tester.getDialog().getResponseText();
        }
        log.log(thrownException);
        if (dumpHtml) {
            log.log((Object)"______________________________ Starting HTML dump");
            CurrentHttpInformation.Info httpInfo = CurrentHttpInformation.getInfo();
            if (httpInfo != null) {
                log.log((Object)("URL              : " + httpInfo.getUrl()));
                log.log((Object)("HTTP METHOD      : " + httpInfo.getRequestMethod()));
                log.log((Object)("HTTP SC          : " + httpInfo.getStatusCode()));
                log.log((Object)("HTTP MSG         : " + httpInfo.getStatusMessage()));
                TestCaseDumpKit.dumpHeaders(log, "Request", httpInfo.getRequestHeaders());
                TestCaseDumpKit.dumpHeaders(log, "Response", httpInfo.getResponseHeaders());
            }
            TestCaseDumpKit.dumpBody(log, responseText);
            log.log((Object)"______________________________ Ending HTML dump \n");
            new ArtifactDumper(testCase, thrownException, when, (FuncTestLogger)log);
        }
    }

    private static void dumpHeaders(FuncTestLoggerImpl log, String typeOfHeaders, Map<String, String[]> headers) {
        log.log((Object)("" + typeOfHeaders + " Headers : "));
        log.log((Object)"________________");
        for (String headerName : headers.keySet()) {
            String[] values;
            StringBuilder sb = new StringBuilder();
            for (String value : values = headers.get(headerName)) {
                sb.append("   ").append(headerName).append(" :").append(" ").append(value);
            }
            log.log((Object)sb);
        }
    }

    private static void dumpBody(FuncTestLoggerImpl log, String responseText) {
        log.log((Object)"Last Successful Response Body : ");
        log.log((Object)"________________");
        log.log((Object)responseText.trim());
    }
}

