/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.functest.framework.changehistory;

import com.atlassian.jira.functest.framework.changehistory.ChangeHistoryField;
import com.atlassian.jira.functest.framework.changehistory.ChangeHistoryList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;

public class ChangeHistorySet {
    final ChangeHistoryList containingChangeHistoryList;
    final String changedBy;
    final Set fieldChanges = new HashSet();

    public ChangeHistorySet(ChangeHistoryList changeHistoryList, String changedBy) {
        this.containingChangeHistoryList = changeHistoryList;
        this.changedBy = ChangeHistoryField.canonical(changedBy);
    }

    public ChangeHistorySet(ChangeHistorySet changeHistorySet) {
        this(changeHistorySet.getContainingChangeHistoryList(), changeHistorySet.changedBy);
        this.fieldChanges.addAll(changeHistorySet.getFieldChanges());
    }

    public ChangeHistoryList getContainingChangeHistoryList() {
        return this.containingChangeHistoryList;
    }

    public String getChangedBy() {
        return this.changedBy;
    }

    public Set getFieldChanges() {
        return this.fieldChanges;
    }

    public ChangeHistorySet add(String fieldName, String oldValue, String newValue) {
        ChangeHistoryField field = new ChangeHistoryField(this, fieldName, oldValue, newValue);
        this.fieldChanges.add(field);
        return this;
    }

    public ChangeHistorySet add(String fieldName, String newValue) {
        ChangeHistoryField lastValue = this.lastOf(fieldName);
        if (lastValue != null) {
            return this.add(fieldName, lastValue.getNewValue(), newValue);
        }
        return this.add(fieldName, "", newValue);
    }

    public ChangeHistoryField lastOf(String fieldName) {
        int len;
        for (int i = len = this.containingChangeHistoryList.size() - 1; i >= 0; --i) {
            ChangeHistorySet set = (ChangeHistorySet)this.containingChangeHistoryList.get(i);
            Iterator iterator = set.iterator();
            while (iterator.hasNext()) {
                ChangeHistoryField field = (ChangeHistoryField)iterator.next();
                if (!field.getFieldName().equals(fieldName)) continue;
                return field;
            }
        }
        return null;
    }

    public Iterator iterator() {
        return this.fieldChanges.iterator();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ChangeHistorySet that = (ChangeHistorySet)o;
        if (this.changedBy != null ? !this.changedBy.equals(that.changedBy) : that.changedBy != null) {
            return false;
        }
        return !(this.fieldChanges != null ? !this.fieldChanges.equals(that.fieldChanges) : that.fieldChanges != null);
    }

    public int hashCode() {
        int result = this.changedBy != null ? this.changedBy.hashCode() : 0;
        result = 31 * result + (this.fieldChanges != null ? this.fieldChanges.hashCode() : 0);
        return result;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("\n\tChange By : ").append(this.changedBy);
        for (Object o : this.fieldChanges) {
            ChangeHistoryField changeHistoryField = (ChangeHistoryField)o;
            sb.append("\n\t");
            sb.append(changeHistoryField.toString());
        }
        sb.append("\n");
        return sb.toString();
    }

    public boolean isSuperSetOf(ChangeHistorySet that) {
        if (this == that) {
            return true;
        }
        if (that == null || this.getClass() != that.getClass()) {
            return false;
        }
        if (this.changedBy != null ? !this.changedBy.equals(that.changedBy) : that.changedBy != null) {
            return false;
        }
        Set thisFields = this.getFieldChanges();
        Set thatFields = that.getFieldChanges();
        if (thisFields.size() == 0 && thatFields.size() == 0) {
            return true;
        }
        for (Object o : thatFields) {
            ChangeHistoryField thatField = (ChangeHistoryField)o;
            if (thisFields.contains(thatField)) continue;
            return false;
        }
        return true;
    }
}

