/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.functest.framework.backdoor;

import com.atlassian.jira.testkit.client.JIRAEnvironmentData;
import com.atlassian.jira.testkit.client.RestApiClient;
import com.atlassian.jira.testkit.client.WorkflowsControl;
import com.atlassian.jira.testkit.client.restclient.Response;
import com.google.common.collect.Maps;
import com.sun.jersey.api.client.ClientResponse;
import com.sun.jersey.api.client.GenericType;
import com.sun.jersey.api.client.WebResource;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.codehaus.jackson.annotate.JsonAutoDetect;
import org.codehaus.jackson.annotate.JsonCreator;
import org.codehaus.jackson.annotate.JsonIgnoreProperties;
import org.codehaus.jackson.annotate.JsonProperty;

public class WorkflowsControlExt
extends WorkflowsControl {
    public WorkflowsControlExt(JIRAEnvironmentData environmentData) {
        super(environmentData);
    }

    public List<Workflow> getWorkflowsDetailed() {
        return (List)this.createExtResource().get(Workflow.LIST);
    }

    public Workflow getWorkflowDetailed(final String name) {
        Response response = this.toResponse(new RestApiClient.Method(){

            public ClientResponse call() {
                return (ClientResponse)WorkflowsControlExt.this.createExtResource().queryParam("name", name).get(ClientResponse.class);
            }
        }, Workflow.class);
        return (Workflow)response.body;
    }

    public Workflow createWorkflow(String name) {
        return (Workflow)this.createExtResource().entity((Object)name).post(Workflow.class);
    }

    public Workflow createDraftOfWorkflow(String parentName) {
        return (Workflow)this.createExtResource().path("createdraft").entity((Object)parentName).post(Workflow.class);
    }

    public void setDescription(String name, String description) {
        this.createExtResource().path(name).entity((Object)description).post();
    }

    public void deleteWorkflow(String name) {
        this.createExtResource().queryParam("name", name).delete();
    }

    private WebResource createExtResource() {
        return this.createResourceForPath("func-test").path("workflow");
    }

    private WebResource createRestAPIResource() {
        return this.createResourceForPath("api", "2").path("workflow");
    }

    public void setTransitionProperty(String workflowName, boolean draft, long transitionID, String key, Object value) {
        this.createRestAPIResource().path("transitions").path(String.valueOf(transitionID)).path("properties").queryParam("workflowName", workflowName).queryParam("key", key).queryParam("workflowMode", draft ? "draft" : "live").entity((Object)new PropertyBean(key, value.toString())).put();
    }

    public Map<String, String> getProperties(String workflowName, boolean draft, long transitionId) {
        List propertyBeans = (List)this.createRestAPIResource().path("transitions").path(String.valueOf(transitionId)).path("properties").queryParam("workflowName", workflowName).queryParam("workflowMode", draft ? "draft" : "live").get(PropertyBean.LIST);
        HashMap result = Maps.newHashMap();
        for (PropertyBean property : propertyBeans) {
            result.put(property.getKey(), property.getValue());
        }
        return result;
    }

    @JsonAutoDetect
    public static class Workflow {
        private static final GenericType<List<Workflow>> LIST = new GenericType<List<Workflow>>(){};
        private String name;
        private String description;
        private boolean hasDraft;

        public String getDescription() {
            return this.description;
        }

        public void setDescription(String description) {
            this.description = description;
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public boolean isHasDraft() {
            return this.hasDraft;
        }

        public void setHasDraft(boolean hasDraft) {
            this.hasDraft = hasDraft;
        }
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static class PropertyBean {
        private static final GenericType<List<PropertyBean>> LIST = new GenericType<List<PropertyBean>>(){};
        private final String key;
        private final String value;

        @JsonCreator
        public PropertyBean(@JsonProperty(value="key") String key, @JsonProperty(value="value") String value) {
            this.key = StringUtils.stripToNull((String)key);
            this.value = StringUtils.stripToEmpty((String)value);
        }

        @JsonProperty
        public String getKey() {
            return this.key;
        }

        @JsonProperty
        public String getValue() {
            return this.value;
        }

        @JsonProperty
        public String getId() {
            return this.getKey();
        }
    }
}

