/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.functest.framework.backdoor;

import com.atlassian.jira.functest.framework.backdoor.IndexingControl;
import com.atlassian.jira.project.ProjectCategory;
import com.atlassian.jira.rest.v2.issue.project.ProjectCategoryBean;
import com.atlassian.jira.testkit.beans.WorkflowSchemeData;
import com.atlassian.jira.testkit.client.JIRAEnvironmentData;
import com.atlassian.jira.testkit.client.ProjectControl;
import com.atlassian.jira.testkit.client.restclient.Component;
import com.atlassian.jira.testkit.client.restclient.Project;
import com.atlassian.jira.testkit.client.restclient.ProjectClient;
import com.atlassian.jira.testkit.client.restclient.Version;
import com.sun.jersey.api.client.GenericType;
import com.sun.jersey.api.client.WebResource;
import java.util.List;

public class ProjectControlExt
extends ProjectControl {
    private final ProjectClient projectClient;
    private final IndexingControl indexingControl;

    public ProjectControlExt(com.atlassian.jira.webtests.util.JIRAEnvironmentData environmentData) {
        super((JIRAEnvironmentData)environmentData);
        this.projectClient = new ProjectClient((JIRAEnvironmentData)environmentData);
        this.indexingControl = new IndexingControl(environmentData);
    }

    public WorkflowSchemeData setWorkflowScheme(String projectKey, long id) {
        return (WorkflowSchemeData)this.createWorkflowSchemeResource(projectKey).post(WorkflowSchemeData.class, (Object)id);
    }

    public void setDefaultWorkflowScheme(String projectKey) {
        this.createWorkflowSchemeResource(projectKey).delete();
    }

    private WebResource createWorkflowSchemeResource(String projectKey) {
        return this.createResourceForPath("func-test").path("project").path(projectKey).path("workflowscheme");
    }

    public void addProjectKey(Long projectId, String previousProjectKey) {
        this.createProjectKeysResource(projectId).put((Object)previousProjectKey);
    }

    public void editProjectKey(Long projectId, String newProjectKey) {
        this.editProjectKeyNoWaitForReindex(projectId, newProjectKey);
        this.indexingControl.getProjectIndexingProgress(projectId).waitForCompletion();
    }

    public void editProjectKeyNoWaitForReindex(Long projectId, String newProjectKey) {
        this.createProjectKeyResource(projectId).put((Object)newProjectKey);
    }

    public Project getProject(String projectKey) {
        return this.projectClient.get(projectKey);
    }

    public List<Project> getProjects() {
        return this.projectClient.getProjects();
    }

    public List<Version> getVersionsForProject(String projectKey) {
        return this.projectClient.getVersions(projectKey);
    }

    public List<Component> getComponentsForProject(String projectKey) {
        return this.projectClient.getComponents(projectKey);
    }

    public Long getProjectId(String projectKey) {
        return (Long)this.createProjectResource(projectKey).path("id").get(Long.class);
    }

    public String getProjectCategoryName(String projectKey) {
        return (String)this.createProjectResource(projectKey).path("category").path("name").get(String.class);
    }

    public List<String> getProjectKeys(Long projectId) {
        return (List)this.createProjectKeysResource(projectId).get((GenericType)new GenericType<List<String>>(){});
    }

    public String getProjectName(Long projectId) {
        return (String)this.createProjectResourceWithId(projectId).path("name").get(String.class);
    }

    public ProjectCategoryBean addProjectCategory(String name) {
        return this.addProjectCategory(name, "");
    }

    public ProjectCategoryBean addProjectCategory(String name, String description) {
        ProjectCategoryBean category = new ProjectCategoryBean((ProjectCategory)new ProjectCategoryImpl(null, name, description), null);
        return (ProjectCategoryBean)this.createProjectCategoryResource().post(ProjectCategoryBean.class, (Object)category);
    }

    public void deleteProjectCategory(String id) {
        this.createProjectCategoryResource().path(id).delete();
    }

    private WebResource createProjectKeysResource(Long projectId) {
        return this.createProjectResourceWithId(projectId).path("keys");
    }

    private WebResource createProjectKeyResource(Long projectId) {
        return this.createProjectResourceWithId(projectId).path("key");
    }

    private WebResource createProjectResourceWithId(Long projectId) {
        return this.createProjectResource(Long.toString(projectId));
    }

    private WebResource createProjectCategoryResource() {
        return this.createResourceForPath("api", "2").path("projectCategory");
    }

    private WebResource createProjectResource(String projectIdOrKey) {
        return this.createResourceForPath("func-test").path("project").path(projectIdOrKey);
    }

    private class ProjectCategoryImpl
    implements ProjectCategory {
        private Long id;
        private String name;
        private String description;

        private ProjectCategoryImpl(Long id, String name, String description) {
            this.id = id;
            this.name = name;
            this.description = description;
        }

        public Long getId() {
            return this.id;
        }

        public String getName() {
            return this.name;
        }

        public String getDescription() {
            return this.description;
        }
    }
}

