/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.functest.framework.backdoor;

import com.atlassian.jira.testkit.client.JIRAEnvironmentData;
import com.atlassian.jira.testkit.client.RestApiClient;
import com.atlassian.jira.testkit.client.restclient.Response;
import com.google.common.base.Function;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.sun.jersey.api.client.ClientResponse;
import com.sun.jersey.api.client.GenericType;
import com.sun.jersey.api.client.WebResource;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import javax.ws.rs.core.MediaType;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.codehaus.jackson.annotate.JsonIgnoreProperties;
import org.codehaus.jackson.annotate.JsonProperty;

public class LicenseRoleControl
extends RestApiClient<LicenseRoleControl> {
    public static final String BUSINESS_USER = "com.atlassian.jira.platform".intern();

    public LicenseRoleControl(com.atlassian.jira.webtests.util.JIRAEnvironmentData environmentData) {
        super((JIRAEnvironmentData)environmentData);
    }

    public List<LicenseRoleBean> getRoles() {
        return (List)this.createLicenseRoleResource().get(LicenseRoleBean.LIST);
    }

    public Map<String, LicenseRoleBean> getRolesMap() {
        return Maps.uniqueIndex(this.getRoles(), (Function)LicenseRoleBean.GET_ID);
    }

    public Response<List<LicenseRoleBean>> getRolesResponse() {
        return this.toResponse(new RestApiClient.Method(){

            public ClientResponse call() {
                return (ClientResponse)LicenseRoleControl.this.createLicenseRoleResource().get(ClientResponse.class);
            }
        }, LicenseRoleBean.LIST);
    }

    public LicenseRoleBean getRole(String role) {
        return (LicenseRoleBean)this.createLicenseRoleResource().path(role).get(LicenseRoleBean.class);
    }

    public LicenseRoleBean getBusinessUser() {
        return this.getRole(BUSINESS_USER);
    }

    public Response<LicenseRoleBean> getRoleResponse(final String role) {
        return this.toResponse(new RestApiClient.Method(){

            public ClientResponse call() {
                return (ClientResponse)LicenseRoleControl.this.createLicenseRoleResource().path(role).get(ClientResponse.class);
            }
        }, LicenseRoleBean.class);
    }

    public LicenseRoleBean putRole(String role, String ... groups) {
        return (LicenseRoleBean)this.createLicenseRoleResource().path(role).type(MediaType.APPLICATION_JSON_TYPE).put(LicenseRoleBean.class, (Object)new LicenseRoleBean(groups));
    }

    public LicenseRoleBean putRoleWithPrimary(String role, String primaryGroup, String ... groups) {
        return (LicenseRoleBean)this.createLicenseRoleResource().path(role).type(MediaType.APPLICATION_JSON_TYPE).put(LicenseRoleBean.class, (Object)new LicenseRoleBean(groups).setPrimaryGroup(primaryGroup));
    }

    public Response<LicenseRoleBean> putRoleResponse(final String role, final String ... groups) {
        return this.toResponse(new RestApiClient.Method(){

            public ClientResponse call() {
                return (ClientResponse)LicenseRoleControl.this.createLicenseRoleResource().path(role).type(MediaType.APPLICATION_JSON_TYPE).put(ClientResponse.class, (Object)new LicenseRoleBean(groups));
            }
        }, LicenseRoleBean.class);
    }

    public LicenseRoleBean putBusinessUser(String ... groups) {
        return this.putRole(BUSINESS_USER, groups);
    }

    private WebResource createLicenseRoleResource() {
        return this.createResource().path("licenserole");
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static class LicenseRoleBean {
        private static final GenericType<List<LicenseRoleBean>> LIST = new GenericType<List<LicenseRoleBean>>(){};
        private static final Function<LicenseRoleBean, String> GET_ID = new Function<LicenseRoleBean, String>(){

            public String apply(LicenseRoleBean input) {
                return input.id;
            }
        };
        @JsonProperty
        private String name;
        @JsonProperty
        private String id;
        @JsonProperty
        private List<String> groups;
        @JsonProperty
        private String primaryGroup;

        public LicenseRoleBean() {
            this.groups = Lists.newArrayList();
        }

        private LicenseRoleBean(String ... groups) {
            this.groups = Arrays.asList(groups);
        }

        public String toString() {
            return new ToStringBuilder((Object)this).append("name", (Object)this.name).append("id", (Object)this.id).append("groups", this.groups).toString();
        }

        public String getName() {
            return this.name;
        }

        public String getId() {
            return this.id;
        }

        public List<String> getGroups() {
            return this.groups;
        }

        public String getPrimaryGroup() {
            return this.primaryGroup;
        }

        public LicenseRoleBean setPrimaryGroup(String primary) {
            this.primaryGroup = primary;
            return this;
        }
    }
}

