/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.functest.framework.backdoor;

import com.atlassian.jira.functest.framework.backdoor.BackdoorControl;
import com.atlassian.jira.testkit.client.JIRAEnvironmentData;
import com.google.common.base.Function;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterators;
import com.sun.jersey.api.client.WebResource;
import com.sun.jersey.core.util.MultivaluedMapImpl;
import java.util.Iterator;
import java.util.List;
import org.codehaus.jackson.JsonNode;
import org.codehaus.jackson.node.ArrayNode;

public class IssuesControl
extends BackdoorControl<IssuesControl> {
    public static final String LIST_VIEW_LAYOUT = "list-view";

    public IssuesControl(JIRAEnvironmentData environmentData) {
        super(environmentData);
    }

    public String getIssueKeyForSummary(String summary) {
        return this.get(this.createResource().path("issues/issueKeyForSummary").queryParam("summary", summary));
    }

    public String getIssueIdByCurrentKey(String key) {
        return this.get(this.createResource().path("issues/issueIdByKey").queryParam("key", key));
    }

    public String getExportOptions(String jql, String filterId, String modified) {
        MultivaluedMapImpl params = new MultivaluedMapImpl();
        if (jql != null) {
            params.add((Object)"jql", (Object)jql);
        }
        if (filterId != null) {
            params.add((Object)"filterId", (Object)filterId);
        }
        if (modified != null) {
            params.add((Object)"modified", (Object)modified);
        }
        WebResource resource = this.resourceRoot(this.rootPath).path("rest/issueNav/1/issueNav/operations/views");
        return (String)resource.header("X-Atlassian-Token", (Object)"nocheck").post(String.class, (Object)params);
    }

    public void setPreferredSearchLayout(String layoutKey, String username) {
        this.loginAs(username);
        WebResource resource = this.resourceRoot(this.rootPath).path("rest/issueNav/latest/preferredSearchLayout");
        MultivaluedMapImpl parameters = new MultivaluedMapImpl();
        parameters.add((Object)"layoutKey", (Object)layoutKey);
        resource.header("X-Atlassian-Token", (Object)"nocheck").post((Object)parameters);
    }

    public void touch(String key) {
        this.put(this.createResource().path("issues/touch").queryParam("key", key));
    }

    private void put(WebResource webResource) {
        webResource.put();
    }

    public List<JsonNode> getHistoryMetadata(String issueKey) {
        WebResource resource = this.resourceRoot(this.rootPath).path("rest/api/2/issue/" + issueKey).queryParam("expand", "changelog");
        JsonNode issue = (JsonNode)resource.get(JsonNode.class);
        ArrayNode histories = (ArrayNode)issue.get("changelog").get("histories");
        return ImmutableList.copyOf((Iterator)Iterators.transform((Iterator)histories.getElements(), (Function)new Function<JsonNode, JsonNode>(){

            public JsonNode apply(JsonNode input) {
                return input.get("historyMetadata");
            }
        }));
    }
}

