/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.functest.framework.backdoor;

import com.atlassian.jira.functest.framework.backdoor.BackdoorControl;
import com.atlassian.jira.index.request.ReindexRequestType;
import com.atlassian.jira.index.request.SharedEntityType;
import com.atlassian.jira.issue.index.IssueIndexingParams;
import com.atlassian.jira.util.Supplier;
import com.atlassian.jira.webtests.util.JIRAEnvironmentData;
import com.sun.jersey.api.client.WebResource;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class IndexingControl
extends BackdoorControl<IndexingControl> {
    public IndexingControl(JIRAEnvironmentData environmentData) {
        super(environmentData);
    }

    @Nonnull
    public IndexingProgress startInBackground() {
        return this.startInBackground(IssueIndexingParams.INDEX_ISSUE_ONLY);
    }

    @Nonnull
    public IndexingProgress startInBackground(IssueIndexingParams issueIndexingParams) {
        final String taskId = (String)this.createResource().path("indexing").path("background").queryParam("comments", String.valueOf(issueIndexingParams.isIndexComments())).queryParam("changeHistory", String.valueOf(issueIndexingParams.isIndexChangeHistory())).queryParam("worklogs", String.valueOf(issueIndexingParams.isIndexWorklogs())).queryParam("issues", String.valueOf(issueIndexingParams.isIndexIssues())).post(String.class);
        return new IndexingProgress(){

            @Override
            boolean isIndexing() {
                return IndexingControl.this.isIndexingInProgress();
            }

            @Override
            boolean isIndexingStarted() {
                return IndexingControl.this.checkIsIndexingStarted();
            }

            @Override
            public String getTaskId() {
                return taskId;
            }
        };
    }

    @Nonnull
    public IndexingProgress startStopTheWorldReIndex() {
        this.createResource().path("indexing").path("stoptheworld").post();
        return new DefaultIndexingProgress();
    }

    @Nullable
    public Boolean getIndexingTaskProgress(String taskId) {
        Map rawValues = (Map)this.resourceRoot(this.getEnvironmentData().getBaseUrl().toExternalForm()).path("rest").path("api").path("2").path("reindex").queryParam("taskId", taskId).get(Map.class);
        return (Boolean)rawValues.get("success");
    }

    @Nonnull
    public IndexingProgress getInBackgroundProgress() {
        return new DefaultIndexingProgress();
    }

    boolean isIndexingInProgress() {
        return (Boolean)this.createResource().path("indexing").get(Boolean.class);
    }

    boolean checkIsIndexingStarted() {
        return (Boolean)this.createResource().path("indexing").path("started").get(Boolean.class);
    }

    @Nonnull
    public IndexingProgress getProjectIndexingProgress(final Long projectId) {
        return new IndexingProgress(){

            @Override
            boolean isIndexing() {
                return IndexingControl.this.isIndexingProject(projectId);
            }

            @Override
            boolean isIndexingStarted() {
                return IndexingControl.this.isIndexingProjectStarted(projectId);
            }

            @Override
            public String getTaskId() {
                return null;
            }
        };
    }

    boolean isIndexingProject(Long projectId) {
        return (Boolean)this.createResource().path("indexing").path("project").queryParam("projectId", projectId.toString()).get(Boolean.class);
    }

    boolean isIndexingProjectStarted(Long projectId) {
        return (Boolean)this.createResource().path("indexing").path("project").path("started").queryParam("projectId", projectId.toString()).get(Boolean.class);
    }

    public boolean isIndexConsistent() {
        return (Boolean)this.createResource().path("indexing").path("consistent").get(Boolean.class);
    }

    public boolean isIndexUpdatedFieldConsistent() {
        return (Boolean)this.createResource().path("indexing").path("consistent").path("updated").get(Boolean.class);
    }

    public void deleteIndex() {
        this.createResource().path("indexing").path("deleteIndex").post();
    }

    public void deindex(String issueKey) {
        this.createResource().path("indexing").path("deindex").queryParam("key", issueKey).get(Boolean.class);
    }

    public void indexDummyIssue(long id, long projectId, String issueType, String issueKey, String summary, String desc) {
        this.createResource().path("indexing").path("indexDummyIssue").queryParam("id", String.valueOf(id)).queryParam("projectId", String.valueOf(projectId)).queryParam("issueType", issueType).queryParam("key", issueKey).queryParam("summary", summary).queryParam("description", desc).get(Boolean.class);
    }

    public void reindexAll() {
        this.createResource().path("indexing").path("reindexAll").post();
    }

    public Long makeReindexRequest(ReindexRequestType type, String query, SharedEntityType ... sharedEntityTypes) {
        WebResource resource = this.createResource().path("indexing").path("makeReindexRequest").queryParam("type", type.name()).queryParam("query", query);
        for (SharedEntityType sharedEntityType : sharedEntityTypes) {
            resource.queryParam("sharedEntityType", sharedEntityType.name());
        }
        return (Long)resource.get(Long.class);
    }

    public Long clearPendingReindexRequests() {
        return (Long)this.createResource().path("indexing").path("clearPendingReindexRequests").get(Long.class);
    }

    public void pauseScheduledReindex() {
        this.createResource().path("indexing").path("scheduledReindex").path("pause").post();
    }

    public void startScheduledReindex() {
        this.createResource().path("indexing").path("scheduledReindex").path("start").post();
    }

    private class DefaultIndexingProgress
    extends IndexingProgress {
        private DefaultIndexingProgress() {
        }

        @Override
        boolean isIndexing() {
            return IndexingControl.this.isIndexingInProgress();
        }

        @Override
        boolean isIndexingStarted() {
            return IndexingControl.this.checkIsIndexingStarted();
        }

        @Override
        public String getTaskId() {
            return null;
        }
    }

    public abstract class IndexingProgress {
        private final long TIMEOUT_MINUTES = 5L;
        private final long MILLIS_PER_CHUNK = 200L;
        private final long MAX_TIMEOUT_IN_CHUNKS = 1500L;
        private long interval = 0L;
        private long overallChunks = 0L;

        public void waitForCompletion() {
            this.poolUntilTrue(new Supplier<Boolean>(){

                @Override
                @Nonnull
                public Boolean get() {
                    return !IndexingProgress.this.isIndexing();
                }
            });
        }

        public void waitForIndexingStarted() {
            this.poolUntilTrue(new Supplier<Boolean>(){

                @Override
                public Boolean get() {
                    return IndexingProgress.this.isIndexingStarted();
                }
            });
        }

        private void poolUntilTrue(Supplier<Boolean> condition) {
            while (!condition.get().booleanValue()) {
                try {
                    Thread.sleep(++this.interval * 200L);
                    this.overallChunks += this.interval;
                    if (this.overallChunks <= 1500L) continue;
                    throw new RuntimeException("Indexing timed out.");
                }
                catch (InterruptedException e) {
                    throw new RuntimeException(e);
                }
            }
        }

        abstract boolean isIndexing();

        abstract boolean isIndexingStarted();

        public abstract String getTaskId();
    }
}

