/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.functest.framework.backdoor;

import com.atlassian.jira.functest.framework.backdoor.BackdoorControl;
import com.atlassian.jira.webtests.util.JIRAEnvironmentData;
import com.google.common.collect.ImmutableList;
import com.sun.jersey.api.client.ClientResponse;
import com.sun.jersey.api.client.GenericType;
import com.sun.jersey.api.client.WebResource;
import com.sun.jersey.core.util.MultivaluedMapImpl;
import java.util.List;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;

public class ColumnControl
extends BackdoorControl<ColumnControl> {
    public ColumnControl(JIRAEnvironmentData environmentData) {
        super(environmentData);
    }

    public List<ColumnItem> getLoggedInUserColumns() {
        return this.getUserColumns(null);
    }

    public boolean setLoggedInUserColumns(List<String> columnIds) {
        return this.setUserColumns(null, columnIds);
    }

    public boolean addLoggedInUserColumns(List<String> columnIds) {
        return this.addUserColumns(null, columnIds);
    }

    public boolean restoreLoggedInUserColumns() {
        return this.restoreUserColumns(null);
    }

    public List<ColumnItem> getUserColumns(String username) {
        WebResource resource = this.createResource().path("user/columns");
        if (username != null) {
            resource = resource.queryParam("username", username);
        }
        return (List)resource.get((GenericType)new GenericType<List<ColumnItem>>(){});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean setUserColumns(String username, List<String> columnIds) {
        WebResource resource = this.createResource().path("user/columns");
        if (username != null) {
            resource = resource.queryParam("username", username);
        }
        MultivaluedMapImpl formData = new MultivaluedMapImpl();
        for (String id : columnIds) {
            formData.add((Object)"columns", (Object)id);
        }
        try (ClientResponse result = (ClientResponse)resource.put(ClientResponse.class, (Object)formData);){
            boolean bl = result.getClientResponseStatus().getStatusCode() == 200;
            return bl;
        }
    }

    public boolean addUserColumns(String username, List<String> columnIds) {
        return this.setUserColumns(username, this.addColumns(this.getUserColumns(username), columnIds));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean restoreUserColumns(String username) {
        WebResource resource = this.createResource().path("user/columns");
        if (username != null) {
            resource = resource.queryParam("username", username);
        }
        try (ClientResponse result = (ClientResponse)resource.delete(ClientResponse.class);){
            boolean bl = result.getClientResponseStatus().getStatusCode() == 200;
            return bl;
        }
    }

    public List<ColumnItem> getFilterColumns(String filterId) {
        WebResource resource = this.createResource().path("filter/" + filterId + "/columns");
        return (List)resource.get((GenericType)new GenericType<List<ColumnItem>>(){});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean setFilterColumns(String filterId, List<String> columnIds) {
        WebResource resource = this.createResource().path("filter/" + filterId + "/columns");
        MultivaluedMapImpl formData = new MultivaluedMapImpl();
        for (String id : columnIds) {
            formData.add((Object)"columns", (Object)id);
        }
        try (ClientResponse result = (ClientResponse)resource.put(ClientResponse.class, (Object)formData);){
            boolean bl = result.getClientResponseStatus().getStatusCode() == 200;
            return bl;
        }
    }

    public List<ColumnItem> getSystemDefaultColumns() {
        WebResource resource = this.createResource().path("settings/columns");
        return (List)resource.get((GenericType)new GenericType<List<ColumnItem>>(){});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean setSystemDefaultColumns(List<String> columnIds) {
        WebResource resource = this.createResource().path("settings/columns");
        MultivaluedMapImpl formData = new MultivaluedMapImpl();
        for (String id : columnIds) {
            formData.add((Object)"columns", (Object)id);
        }
        try (ClientResponse result = (ClientResponse)resource.put(ClientResponse.class, (Object)formData);){
            boolean bl = result.getClientResponseStatus().getStatusCode() == 200;
            return bl;
        }
    }

    private List<String> addColumns(List<ColumnItem> originalColumns, List<String> newColumns) {
        ImmutableList.Builder builder = ImmutableList.builder();
        for (ColumnItem originalColumn : originalColumns) {
            builder.add((Object)originalColumn.value);
        }
        builder.addAll(newColumns);
        return builder.build();
    }

    @Override
    protected WebResource createResource() {
        return this.resourceRoot(this.rootPath).path("rest").path("api").path("2");
    }

    @XmlRootElement
    public static class ColumnItem {
        @XmlElement
        public String label;
        @XmlElement
        public String value;

        public ColumnItem(String value, String label) {
            this.label = label;
            this.value = value;
        }

        ColumnItem() {
        }
    }
}

