/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.functest.framework.assertions;

import com.atlassian.jira.functest.framework.AbstractFuncTestUtil;
import com.atlassian.jira.functest.framework.assertions.ProjectFieldsAssertions;
import com.atlassian.jira.functest.framework.util.RegexMatchers;
import com.atlassian.jira.util.json.JSONArray;
import com.atlassian.jira.util.json.JSONException;
import com.atlassian.jira.util.json.JSONObject;
import com.atlassian.jira.webtests.util.JIRAEnvironmentData;
import com.google.common.base.Function;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import net.sourceforge.jwebunit.WebTester;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.w3c.dom.Element;

public class ProjectFieldsAssertionsImpl
extends AbstractFuncTestUtil
implements ProjectFieldsAssertions {
    public ProjectFieldsAssertionsImpl(WebTester tester, JIRAEnvironmentData environmentData) {
        super(tester, environmentData, 2);
    }

    @Override
    public void assertProjectsEquals(String[] projects) {
        try {
            List<String> projectNamesAvailable = this.getProjectNames();
            ImmutableList expectedOptionsMatchers = ImmutableList.copyOf((Iterable)Iterables.transform((Iterable)ImmutableList.copyOf((Object[])projects), (Function)new Function<String, Matcher<? super String>>(){

                public Matcher<String> apply(@Nullable String input) {
                    return RegexMatchers.regexMatches(input + " \\(.+\\)");
                }
            }));
            Assert.assertThat((Object)ImmutableList.copyOf(projectNamesAvailable), (Matcher)Matchers.contains((List)expectedOptionsMatchers));
        }
        catch (JSONException e) {
            junit.framework.Assert.fail((String)"Exception while parsing project field options");
        }
    }

    @Override
    public void assertIssueTypesEquals(String[] issueTypes) {
        try {
            List<String> issueTypeNames = this.getIssueTypeNames();
            junit.framework.Assert.assertEquals((Object)ImmutableList.copyOf((Object[])issueTypes), (Object)ImmutableList.copyOf(issueTypeNames));
        }
        catch (JSONException e) {
            junit.framework.Assert.fail((String)"Exception while parsing issue type field options");
        }
    }

    @Override
    public void assertIssueTypeIsAvailable(String issueType) {
        try {
            List<String> issueTypeNames = this.getIssueTypeNames();
            junit.framework.Assert.assertTrue((boolean)issueTypeNames.contains(issueType));
        }
        catch (JSONException e) {
            junit.framework.Assert.fail((String)("Could not check if " + issueType + " is available. Exception occured during parsing of issue type field options."));
        }
    }

    @Override
    public void assertIssueTypeIsSelected(String issueType) {
        try {
            String issueTypeId = this.getIssueTypeId(issueType);
            this.tester.assertFormElementEquals("issuetype", issueTypeId);
        }
        catch (JSONException e) {
            junit.framework.Assert.fail((String)("Could not check if " + issueType + " is selected. Exception occured during parsing of issue type field options."));
        }
    }

    private List<String> getProjectNames() throws JSONException {
        ArrayList<String> projectNames = new ArrayList<String>();
        Element options = this.tester.getDialog().getElement("project-options");
        String jsonProjects = options.getAttribute("data-suggestions");
        JSONArray projects = new JSONArray(jsonProjects);
        JSONObject recentProjects = projects.getJSONObject(0);
        for (int i = 0; i < recentProjects.getJSONArray("items").length(); ++i) {
            projectNames.add(recentProjects.getJSONArray("items").getJSONObject(i).getString("label"));
        }
        JSONObject allProjects = projects.getJSONObject(1);
        for (int i = 0; i < allProjects.getJSONArray("items").length(); ++i) {
            projectNames.add(allProjects.getJSONArray("items").getJSONObject(i).getString("label"));
        }
        return projectNames;
    }

    private List<String> getIssueTypeNames() throws JSONException {
        ArrayList<String> issueTypeNames = new ArrayList<String>();
        Element options = this.tester.getDialog().getElement("issuetype-options");
        String jsonIssueTypes = options.getAttribute("data-suggestions");
        JSONArray issueTypes = new JSONArray(jsonIssueTypes);
        for (int i = 0; i < issueTypes.length(); ++i) {
            JSONObject item = issueTypes.getJSONObject(i);
            if (item.has("items")) {
                for (int j = 0; j < item.getJSONArray("items").length(); ++j) {
                    issueTypeNames.add(item.getJSONArray("items").getJSONObject(j).getString("label"));
                }
                continue;
            }
            issueTypeNames.add(item.getString("label"));
        }
        return issueTypeNames;
    }

    private String getIssueTypeId(String issueTypeName) throws JSONException {
        Element options = this.tester.getDialog().getElement("issuetype-options");
        String jsonIssueTypes = options.getAttribute("data-suggestions");
        JSONArray issueTypes = new JSONArray(jsonIssueTypes);
        for (int i = 0; i < issueTypes.length(); ++i) {
            JSONObject item = issueTypes.getJSONObject(i);
            if (item.has("items")) {
                for (int j = 0; j < item.getJSONArray("items").length(); ++j) {
                    if (!issueTypeName.equals(item.getJSONArray("items").getJSONObject(j).getString("label"))) continue;
                    return item.getString("value");
                }
                continue;
            }
            if (!issueTypeName.equals(item.getString("label"))) continue;
            return item.getString("value");
        }
        return null;
    }
}

