/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.functest.framework.assertions;

import com.atlassian.jira.functest.framework.AbstractFuncTestUtil;
import com.atlassian.jira.functest.framework.assertions.LinkAssertions;
import com.atlassian.jira.functest.framework.locator.CssLocator;
import com.atlassian.jira.functest.framework.locator.LocatorEntry;
import com.atlassian.jira.functest.framework.locator.XPathLocator;
import com.atlassian.jira.util.dbc.Assertions;
import com.atlassian.jira.webtests.util.JIRAEnvironmentData;
import com.meterware.httpunit.WebLink;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.List;
import junit.framework.Assert;
import net.sourceforge.jwebunit.HttpUnitDialog;
import net.sourceforge.jwebunit.WebTester;
import org.apache.commons.lang.StringUtils;
import org.w3c.dom.Node;
import org.xml.sax.SAXException;

public class LinkAssertionsImpl
extends AbstractFuncTestUtil
implements LinkAssertions {
    private static final String LITERAL_PLUS = "\\+";

    public LinkAssertionsImpl(WebTester tester, JIRAEnvironmentData environmentData) {
        super(tester, environmentData, 2);
    }

    @Override
    public void assertLinkByIdHasExactText(String linkId, String linkText) {
        CssLocator locator = this.locators.css("a#" + linkId);
        Assert.assertTrue((String)("Could not find link with ID '" + linkId + "'"), (boolean)locator.hasNodes());
        Assert.assertTrue((String)("Page is corrupted. Found more than 1 link with ID '" + linkId + "'"), (locator.getNodes().length == 1 ? 1 : 0) != 0);
        Assert.assertEquals((String)("Unexpected text of the located link with ID '" + linkId + "'"), (String)linkText, (String)locator.getText());
    }

    @Override
    public void assertLinkLocationEndsWith(String linkText, String endsWith) {
        WebLink webLink = this.getLinkWithText(linkText);
        String urlString = webLink.getURLString().trim();
        if (!urlString.endsWith(endsWith)) {
            Assert.fail((String)("Location of link with text '" + linkText + "' expected to end with '" + endsWith + "' but points to '" + urlString + "'."));
        }
    }

    @Override
    public void assertLinkLocationEndsWith(WebLink link, String endsWith) {
        String urlString = link.getURLString().trim();
        if (!urlString.endsWith(endsWith)) {
            Assert.fail((String)("Location of link expected to end with '" + endsWith + "' but points to '" + urlString + "'."));
        }
    }

    @Override
    public void assertLinkAtNodeEndsWith(String xpath, String endsWith) {
        XPathLocator locator = new XPathLocator(this.tester, xpath);
        Assert.assertTrue((String)("Node '" + xpath + "' does not exist."), (boolean)locator.exists());
        String href = locator.getNode().getAttributes().getNamedItem("href").getNodeValue();
        if (!href.endsWith(endsWith)) {
            Assert.fail((String)("Location of link expected to end with '" + endsWith + "' but points to '" + href + "'."));
        }
    }

    @Override
    public void assertLinkAtNodeContains(String xpath, String containsUrl) {
        XPathLocator locator = new XPathLocator(this.tester, xpath);
        Assert.assertTrue((String)("Node '" + xpath + "' does not exist."), (boolean)locator.exists());
        String href = locator.getNode().getAttributes().getNamedItem("href").getNodeValue();
        if (!href.contains(containsUrl)) {
            Assert.fail((String)("Location of link expected to contain '" + containsUrl + "' but points to '" + href + "'."));
        }
    }

    @Override
    public void assertLinkIdQueryStringContainsJqlQuery(String linkId, String expectedJqlQuery) {
        this.assertLinkQueryStringContainsJqlQuery(this.getLinkWithId(linkId), expectedJqlQuery);
    }

    @Override
    public void assertLinkTextQueryStringContainsJqlQuery(String xpath, String linkText, String expectedJqlQuery) {
        List<String> hrefs = this.getHrefsFromLinkNodeWithExactText(xpath, linkText);
        for (String href : hrefs) {
            boolean found = this.doesHrefContainsJqlQuery(href, expectedJqlQuery);
            if (!found) continue;
            return;
        }
        Assert.fail((String)String.format("Could not find any links with text '%s' in xpath '%s' that contained the jql '%s'", linkText, xpath, expectedJqlQuery));
    }

    @Override
    public void assertLinkQueryStringContainsJqlQuery(WebLink link, String expectedJqlQuery) {
        if (StringUtils.isEmpty((String)link.getURLString())) {
            Assert.fail((String)("No URL for link with id [" + link.getID() + "]"));
        }
        boolean foundSubString = this.doesHrefContainsJqlQuery(link.getURLString(), expectedJqlQuery);
        Assert.assertTrue((String)String.format("Could not find jql '%s' in URL '%s'", expectedJqlQuery, link.getURLString()), (boolean)foundSubString);
    }

    private boolean doesHrefContainsJqlQuery(String href, String expectedJqlQuery) {
        try {
            String urlSubstringWithPlusses = "jqlQuery=" + URLEncoder.encode(expectedJqlQuery, "UTF-8");
            return href.contains(urlSubstringWithPlusses) || href.contains(urlSubstringWithPlusses.replaceAll(LITERAL_PLUS, "%20"));
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void assertLinkIdLocationEndsWith(String linkId, String endsWith) {
        WebLink webLink = this.getLinkWithId(linkId);
        String urlString = webLink.getURLString().trim();
        if (!urlString.endsWith(endsWith)) {
            Assert.fail((String)("Location of link with id '" + linkId + "' expected to end with '" + endsWith + "' but points to '" + urlString + "'."));
        }
    }

    @Override
    public void assertLinkIdLocationMatchesRegex(String linkId, String regex) {
        WebLink webLink = this.getLinkWithId(linkId);
        String urlString = webLink.getURLString().trim();
        if (!urlString.matches(regex)) {
            Assert.fail((String)("Location of link with id '" + linkId + "' expected to match regex '" + regex + "' but points to '" + urlString + "'."));
        }
    }

    @Override
    public void assertLinkPresentWithExactText(String xpath, String text) {
        XPathLocator locator = new XPathLocator(this.tester, xpath + "//a[text()=\"" + text + "\"]");
        Assert.assertTrue((String)("Could not find a single link with the exact text \"" + text + "\" using locator: " + locator), (locator.getNodes().length > 0 ? 1 : 0) != 0);
    }

    @Override
    public void assertLinkNotPresentWithExactText(String xpath, String text) {
        XPathLocator locator = new XPathLocator(this.tester, xpath + "//a[text()=\"" + text + "\"]");
        Assert.assertTrue((String)("Found a link with the exact text \"" + text + "\" using locator: " + locator), (locator.getNodes().length == 0 ? 1 : 0) != 0);
    }

    @Override
    public void assertLinkPresentWithExactTextById(String regionId, String text) {
        Assertions.notNull("regionId", regionId);
        Assertions.notNull("text", text);
        CssLocator allLinks = this.locators.css("#" + regionId + " a");
        for (LocatorEntry singleLink : allLinks.allMatches()) {
            if (!text.equals(singleLink.getText())) continue;
            return;
        }
        Assert.fail((String)("Link with text '" + text + "' not found within section with ID '" + regionId + "'"));
    }

    @Override
    public void assertLinkNotPresentContainingTextById(String regionId, String text) {
        Assertions.notNull("regionId", regionId);
        Assertions.notNull("text", text);
        CssLocator allLinks = this.locators.css("#" + regionId + " a");
        for (LocatorEntry singleLink : allLinks.allMatches()) {
            Assert.assertFalse((String)("Not extpected link with text '" + text + "' found within section with ID '" + regionId + "'"), (singleLink.getText() != null && singleLink.getText().contains(text) ? 1 : 0) != 0);
        }
    }

    @Override
    public void assertLinkWithExactTextAndUrlPresent(String expectedExactText, String expectedUrlSuffix) {
        for (String href : this.getHrefsFromLinkNodeWithExactText("", expectedExactText)) {
            if (!href.endsWith(expectedUrlSuffix)) continue;
            return;
        }
        Assert.fail((String)("No link with exact text '" + expectedExactText + "' and URL suffix '" + expectedUrlSuffix + "' found"));
    }

    private List<String> getHrefsFromLinkNodeWithExactText(String xpath, String text) {
        XPathLocator locator = new XPathLocator(this.tester, xpath + "//a");
        if (locator.getNodes().length == 0) {
            throw new IllegalArgumentException("Could not find any links with the text '" + text + "' from xpath '" + xpath + "'.");
        }
        ArrayList<Node> matchedNodes = new ArrayList<Node>();
        for (Node node : locator.getNodes()) {
            String nodeText = locator.getText(node);
            if (!text.equals(nodeText)) continue;
            matchedNodes.add(node);
        }
        ArrayList<String> hrefs = new ArrayList<String>();
        for (Node aNode : matchedNodes) {
            hrefs.add(aNode.getAttributes().getNamedItem("href").getNodeValue());
        }
        return hrefs;
    }

    private WebLink getLinkWithText(String text) {
        WebLink webLink;
        try {
            HttpUnitDialog dialog = this.tester.getDialog();
            if (!dialog.isLinkPresentWithText(text)) {
                Assert.fail((String)("Link with text'" + text + "' does not exist."));
            }
            webLink = dialog.getResponse().getLinkWith(text);
        }
        catch (SAXException e) {
            AssertionError error = new AssertionError((Object)("Link with text '" + text + "' does not exist."));
            ((Throwable)((Object)error)).initCause(e);
            throw error;
        }
        return webLink;
    }

    private WebLink getLinkWithId(String linkId) {
        WebLink webLink;
        try {
            HttpUnitDialog dialog = this.tester.getDialog();
            if (!dialog.isLinkPresent(linkId)) {
                Assert.fail((String)("Link with id'" + linkId + "' does not exist."));
            }
            webLink = dialog.getResponse().getLinkWithID(linkId);
        }
        catch (SAXException e) {
            AssertionError error = new AssertionError((Object)("Link with id '" + linkId + "' does not exist."));
            ((Throwable)((Object)error)).initCause(e);
            throw error;
        }
        return webLink;
    }
}

