/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.functest.framework.assertions;

import com.atlassian.jira.functest.framework.AbstractFuncTestUtil;
import com.atlassian.jira.functest.framework.assertions.JiraFormAssertions;
import com.atlassian.jira.functest.framework.assertions.TextAssertions;
import com.atlassian.jira.functest.framework.locator.CssLocator;
import com.atlassian.jira.functest.framework.locator.Locator;
import com.atlassian.jira.functest.framework.locator.LocatorEntry;
import com.atlassian.jira.functest.framework.locator.XPathLocator;
import com.atlassian.jira.webtests.util.JIRAEnvironmentData;
import junit.framework.Assert;
import net.sourceforge.jwebunit.WebTester;

public class JiraFormAssertionsImpl
extends AbstractFuncTestUtil
implements JiraFormAssertions {
    private static final String AUI_MESSAGE_ERROR_CSS = ".aui-message.error";
    private static final String AUI_MESSAGE_WARNING_CSS = ".aui-message.warning";
    private static final String AUI_MESSAGE_INFO_CSS = ".aui-message.info";
    private final TextAssertions textAssertions;

    public JiraFormAssertionsImpl(TextAssertions textAssertions, WebTester tester, JIRAEnvironmentData environmentData) {
        super(tester, environmentData, 2);
        this.textAssertions = textAssertions;
    }

    @Override
    public void assertFieldErrMsg(String expectedText) {
        Locator error = this.createFieldErrorMessageLocator();
        this.textAssertions.assertTextPresent(error, expectedText);
    }

    @Override
    public void assertAuiFieldErrMsg(String expectedText) {
        Locator error = this.createAuiFieldErrorMessageLocator();
        this.textAssertions.assertTextPresent(error, expectedText);
    }

    @Override
    public void assertFormErrMsg(String expectedText) {
        Locator error = this.createFormErrorMessageLocator();
        this.textAssertions.assertTextPresent(error, expectedText);
    }

    @Override
    public void assertFormErrMsgContainsLink(String linkExactText) {
        CssLocator linksInErrorMsg = this.locators.css(".aui-message.error a");
        if (!this.nodeWithTextExists(linkExactText, linksInErrorMsg)) {
            Assert.fail((String)("Link with text '" + linkExactText + "' not found in any error message"));
        }
    }

    private boolean nodeWithTextExists(String linkExactText, Locator linksInErrorMsg) {
        for (LocatorEntry link : linksInErrorMsg.allMatches()) {
            if (!linkExactText.equals(link.getText())) continue;
            return true;
        }
        return false;
    }

    @Override
    public void assertNoFieldErrMsg(String notExpectedText) {
        this.textAssertions.assertTextNotPresent(this.createFieldErrorMessageLocator(), notExpectedText);
    }

    @Override
    public void assertNoFormErrMsg(String notExpectedText) {
        this.textAssertions.assertTextNotPresent(this.createFormErrorMessageLocator(), notExpectedText);
    }

    @Override
    public void assertNoErrorsPresent() {
        Locator errorLocator = this.createFieldErrorMessageLocator();
        Assert.assertNull((String)"Expected no errors on the page, but there was a field with an error.", (Object)errorLocator.getNode());
        errorLocator = this.createFormErrorMessageLocator();
        Assert.assertNull((String)"Expected no errors on the page, but the page had a global error.", (Object)errorLocator.getNode());
    }

    @Override
    public void assertSelectElementHasOptionSelected(String selectElementName, String optionName) {
        String actual = this.tester.getDialog().getSelectedOption(selectElementName);
        Assert.assertEquals((String)("Expected option selected '" + optionName + "' was not selected in form element '" + selectElementName + "'. Actual selected option was '" + actual + "'."), (String)optionName, (String)actual);
    }

    @Override
    public void assertFormNotificationMsg(String expectedText) {
        Locator notification = this.createFormNotificationMessageLocator();
        this.textAssertions.assertTextPresent(notification, expectedText);
    }

    @Override
    public void assertNoFormNotificationMsg(String notExpectedText) {
        this.textAssertions.assertTextNotPresent(this.createFormNotificationMessageLocator(), notExpectedText);
    }

    @Override
    public void assertFormNotificationMsgContainsLink(String linkExactText) {
        CssLocator linksInErrorMsg = this.locators.css(".aui-message.info a");
        if (!this.nodeWithTextExists(linkExactText, linksInErrorMsg)) {
            Assert.fail((String)("Link with text '" + linkExactText + "' not found in any notification message"));
        }
    }

    @Override
    public void assertFormSuccessMsg(String expectedText) {
        Locator notification = this.createFormSuccessMessageLocator();
        this.textAssertions.assertTextPresent(notification, expectedText);
    }

    @Override
    public void assertFormWarningMessage(String messageText) {
        this.textAssertions.assertTextPresent(this.createFormWarningMessageLocator(), messageText);
    }

    @Override
    public void assertNoFormWarningMessage(String notExpectedText) {
        this.textAssertions.assertTextNotPresent(this.createFormWarningMessageLocator(), notExpectedText);
    }

    @Override
    public void assertFormWarningMessageContainsLink(String linkExactText) {
        CssLocator linksInMsg = this.locators.css(".aui-message.warning a");
        if (!this.nodeWithTextExists(linkExactText, linksInMsg)) {
            Assert.fail((String)("Link with text '" + linkExactText + "' not found in any warning message"));
        }
    }

    private Locator createFieldErrorMessageLocator() {
        return new XPathLocator(this.tester, "//span[@class='errMsg']");
    }

    private Locator createAuiFieldErrorMessageLocator() {
        return new XPathLocator(this.tester, "//form[@class='aui']//div[@class='field-group']/div[@class='error']");
    }

    private Locator createFormErrorMessageLocator() {
        return this.locators.css(AUI_MESSAGE_ERROR_CSS);
    }

    private Locator createFormNotificationMessageLocator() {
        return this.locators.css(AUI_MESSAGE_INFO_CSS);
    }

    private Locator createFormSuccessMessageLocator() {
        return this.locators.css(".aui-message.success");
    }

    private Locator createFormWarningMessageLocator() {
        return this.locators.css(AUI_MESSAGE_WARNING_CSS);
    }
}

