/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.functest.framework.assertions;

import com.atlassian.jira.functest.framework.backdoor.Backdoor;
import com.atlassian.jira.functest.framework.backdoor.FilterInfo;
import com.atlassian.jira.functest.framework.backdoor.FiltersClient;
import com.atlassian.jira.functest.framework.navigator.NavigatorCondition;
import com.atlassian.jira.functest.framework.navigator.NavigatorSearch;
import com.atlassian.jira.functest.framework.sharing.SharedEntityInfo;
import com.atlassian.jira.functest.framework.util.FilteredSearcherGroup;
import com.atlassian.jira.functest.framework.util.IssueTableClient;
import com.atlassian.jira.functest.framework.util.SearchRendererValue;
import com.atlassian.jira.functest.framework.util.SearchResults;
import com.atlassian.jira.functest.framework.util.Searcher;
import com.atlassian.jira.functest.framework.util.SearchersClient;
import com.atlassian.jira.testkit.client.restclient.Response;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.jsoup.Jsoup;
import org.jsoup.nodes.Document;
import org.jsoup.nodes.Element;
import org.jsoup.select.Elements;
import org.junit.Assert;

public class IssueTableAssertions {
    public static final String ORDER_BY_CLAUSE = " ORDER BY key DESC";
    private Backdoor backdoor;

    public IssueTableAssertions(Backdoor backdoor) {
        this.backdoor = backdoor;
    }

    public void assertSearchWithResultsForUser(String username, String jqlString, String ... issueKeys) {
        this.backdoor.issueTableClient().loginAs(username);
        this.assertSearchWithResults(jqlString, issueKeys);
    }

    public void assertSearchWithResults(String jqlString, String ... expectedIssueKeys) {
        this.assertOrderedSearchWithResults(jqlString + ORDER_BY_CLAUSE, expectedIssueKeys);
    }

    public void assertOrderedSearchWithResultsForUser(String username, String jqlString, String[] expectedIssueKeys) {
        this.backdoor.issueTableClient().loginAs(username);
        this.assertOrderedSearchWithResults(jqlString, expectedIssueKeys);
    }

    public void assertOrderedSearchWithResults(String jqlString, String[] expectedIssueKeys) {
        List actualIssueKeys;
        IssueTableClient.ClientIssueTableServiceOutcome issueTable = this.backdoor.issueTableClient().getIssueTable(jqlString);
        String table = issueTable.getIssueTable().getTable();
        if (table != null) {
            Document tableDocument = Jsoup.parse((String)table);
            Elements issuerows = tableDocument.getElementsByClass("issuerow");
            actualIssueKeys = new ArrayList(issuerows.size());
            for (Element row : issuerows) {
                actualIssueKeys.add(row.dataset().get("issuekey"));
            }
        } else {
            actualIssueKeys = Collections.emptyList();
        }
        Assert.assertEquals((String)jqlString, Arrays.asList(expectedIssueKeys), actualIssueKeys);
    }

    public void assertSearchTooComplex(String jqlString) {
        this.assertSearchTooComplex("admin", jqlString);
    }

    public void assertSearchWithErrorForUser(String username, String jqlString, String error) {
        this.backdoor.issueTableClient().loginAs(username);
        this.assertSearchWithError(jqlString, error);
    }

    public void assertSearchWithError(Long filterId, String jqlString, String error) {
        Response response = this.backdoor.issueTableClient().getResponse(filterId, jqlString, null, null, true);
        if (response.statusCode == 200 || response.entity == null || response.entity.errorMessages == null || response.entity.errorMessages.isEmpty()) {
            Assert.fail((String)("Search did not fail or the failure happened in an unexpected way:\n\tfilterId=" + filterId + "\n\tjqlString=" + jqlString + "\n\tresponse=" + response + '\n'));
        }
        Assert.assertEquals((Object)error, response.entity.errorMessages.get(0));
    }

    public void assertSearchWithError(String jqlString, String error) {
        this.assertSearchWithError(null, jqlString, error);
    }

    public void assertSearchWithErrors(String jqlString, List<String> errors) {
        Response response = this.backdoor.issueTableClient().getResponse(null, jqlString, null, null, true);
        Assert.assertEquals(errors, (Object)response.entity.errorMessages);
    }

    public void assertSearchWithError(Long filter, String error) {
        this.assertSearchWithError(filter, null, error);
    }

    public void assertSearchWithWarningForUser(String username, String jqlString, String warning) {
        this.backdoor.issueTableClient().loginAs(username);
        this.assertSearchWithWarning(jqlString, warning);
    }

    public void assertSearchWithWarning(Long filterId, String jql, String warning) {
        IssueTableClient.ClientIssueTableServiceOutcome issueTable = this.backdoor.issueTableClient().getIssueTable(filterId, jql, null, null, true);
        Assert.assertEquals((Object)warning, (Object)issueTable.warnings.get(0));
    }

    public void assertSearchWithWarning(String jqlString, String warning) {
        IssueTableClient.ClientIssueTableServiceOutcome issueTable = this.backdoor.issueTableClient().getIssueTable(jqlString);
        Assert.assertNotNull((String)jqlString, issueTable.warnings);
        Assert.assertEquals((String)jqlString, (Object)warning, (Object)issueTable.warnings.get(0));
    }

    public void assertSearchWithWarning(Long filterId, String warning) {
        IssueTableClient.ClientIssueTableServiceOutcome issueTable = this.backdoor.issueTableClient().getIssueTable(filterId);
        Assert.assertEquals((Object)warning, (Object)issueTable.warnings.get(0));
    }

    public void assertSearchIsValid(Long filterId) {
        Assert.assertNull((Object)this.backdoor.issueTableClient().getResponse((Long)filterId, null, null, null, (Boolean)Boolean.valueOf((boolean)true)).entity);
        IssueTableClient.ClientIssueTableServiceOutcome issueTable = this.backdoor.issueTableClient().getIssueTable(filterId);
        Assert.assertEquals((long)0L, (long)issueTable.warnings.size());
    }

    public void assertSimpleSearch(String user, long filter, NavigatorSearch expectedSearch) {
        FiltersClient filters = this.backdoor.filters();
        SearchersClient searchersClient = this.backdoor.searchersClient();
        if (user != null) {
            searchersClient.loginAs(user);
            filters.loginAs(user);
        }
        String filterJql = filters.getFilterJql(filter);
        SearchResults searchers = searchersClient.getSearchers(filterJql);
        Collection values = searchers.values.values();
        Collection<NavigatorCondition> conditions = expectedSearch.getConditions();
        Document doc = Jsoup.parse((String)"");
        for (SearchRendererValue value : values) {
            doc.append(value.editHtml);
        }
        for (NavigatorCondition condition : conditions) {
            condition.assertSettings(doc);
        }
    }

    public void assertSearchersPresent(String ... searchers) {
        List<String> searcherNames = this.getSearcherNames();
        for (String searcher : searchers) {
            Assert.assertTrue((String)("Expected searchers to contain [" + searcher + "]"), (boolean)searcherNames.contains(searcher));
        }
    }

    private List<String> getSearcherNames() {
        SearchResults searchersResult = this.backdoor.searchersClient().getSearchers("");
        List<FilteredSearcherGroup> groups = searchersResult.searchers.getGroups();
        ArrayList<String> searcherNames = new ArrayList<String>();
        for (FilteredSearcherGroup group : groups) {
            List<Searcher> searcherList = group.getSearchers();
            for (Searcher searcher : searcherList) {
                if (!searcher.getShown().booleanValue()) continue;
                searcherNames.add(searcher.getName());
            }
        }
        return searcherNames;
    }

    public void assertSearchersNotPresent(String ... searchers) {
        List<String> searcherNames = this.getSearcherNames();
        for (String searcher : searchers) {
            Assert.assertFalse((String)("Expected searchers NOT to contain [" + searcher + "]"), (boolean)searcherNames.contains(searcher));
        }
    }

    public void assertSimpleSearch(long filter, NavigatorSearch expectedSearch) {
        this.assertSimpleSearch(null, filter, expectedSearch);
    }

    public void assertSearchInfo(long filter, SharedEntityInfo info) {
        FilterInfo actualFilterInfo = this.backdoor.filters().getFilter(filter);
        String description = info.getDescription().equals("") ? null : info.getDescription();
        Assert.assertEquals((String)"name is wrong", (Object)info.getName(), (Object)actualFilterInfo.name);
        Assert.assertEquals((String)"Description is wrong", (Object)description, (Object)actualFilterInfo.description);
        Assert.assertEquals((String)"Should have been favourited but wasn't", (Object)info.isFavourite(), (Object)actualFilterInfo.favourite);
    }

    public void assertSearchWithWarnings(String jql, List<String> warnings) {
        IssueTableClient.ClientIssueTableServiceOutcome issueTable = this.backdoor.issueTableClient().getIssueTable(jql);
        Assert.assertEquals(warnings, issueTable.warnings);
    }

    public void assertMaxErrors(String jqlString, int maxErrors) {
        Response response = this.backdoor.issueTableClient().getResponse(null, jqlString, null, null, true);
        Assert.assertEquals((long)maxErrors, (long)response.entity.errorMessages.size());
    }

    public void assertFilterErrors(String user, int filterId, List errors) {
        Response response = ((IssueTableClient)this.backdoor.issueTableClient().loginAs(user)).getResponse(Long.valueOf(filterId));
        Assert.assertEquals((Object)errors, (Object)response.entity.errorMessages);
    }

    public void assertFilterError(String user, int filterId, String error) {
        ArrayList<String> errors = new ArrayList<String>();
        errors.add(error);
        this.assertFilterErrors(user, filterId, errors);
    }

    public void assertSearchTooComplex(String user, String jqlString) {
        Response searchersResponse = ((SearchersClient)this.backdoor.searchersClient().loginAs(user)).getSearchersResponse(jqlString);
        Assert.assertEquals((long)searchersResponse.statusCode, (long)400L);
    }
}

