/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.functest.framework.assertions;

import com.atlassian.jira.functest.framework.AbstractNavigationUtil;
import com.atlassian.jira.functest.framework.assertions.IssueNavigatorAssertions;
import com.atlassian.jira.functest.framework.assertions.TextAssertions;
import com.atlassian.jira.functest.framework.locator.IdLocator;
import com.atlassian.jira.functest.framework.locator.Locator;
import com.atlassian.jira.functest.framework.locator.XPathLocator;
import com.atlassian.jira.functest.framework.navigation.IssueNavigatorNavigation;
import com.atlassian.jira.functest.framework.navigator.ContainsIssueKeysCondition;
import com.atlassian.jira.functest.framework.navigator.DoesNotContainIssueKeyCondition;
import com.atlassian.jira.functest.framework.navigator.NavigatorSearch;
import com.atlassian.jira.functest.framework.navigator.NumberOfIssuesCondition;
import com.atlassian.jira.functest.framework.navigator.SearchResultsCondition;
import com.atlassian.jira.functest.framework.sharing.SharedEntityInfo;
import com.atlassian.jira.util.dbc.Assertions;
import com.atlassian.jira.webtests.util.JIRAEnvironmentData;
import com.google.common.base.Function;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import javax.annotation.Nullable;
import net.sourceforge.jwebunit.WebTester;
import org.apache.commons.lang.StringUtils;
import org.junit.Assert;

public class IssueNavigatorAssertionsImpl
extends AbstractNavigationUtil
implements IssueNavigatorAssertions {
    public IssueNavigatorAssertionsImpl(WebTester tester, JIRAEnvironmentData environmentData) {
        super(tester, environmentData);
    }

    @Override
    public void assertSimpleSearch(NavigatorSearch search, WebTester tester) {
        Assert.assertTrue((String)"Fix to work with kickass", (boolean)false);
    }

    @Override
    public void assertAdvancedSearch(WebTester tester, String ... values) {
        String jqlValue = tester.getDialog().getFormParameterValue("jqlQuery");
        for (String value : values) {
            junit.framework.Assert.assertTrue((String)("The string '" + value + "' could not be found in the JQL '" + jqlValue + "'."), (boolean)jqlValue.contains(value));
        }
    }

    @Override
    public void assertSearchInfo(SharedEntityInfo info) {
        XPathLocator locator = new XPathLocator(this.tester, "//*[@id='filter-description']");
        this.getTextAssertions().assertTextPresent(locator, info.getName());
        if (StringUtils.isNotBlank((String)info.getDescription())) {
            this.getTextAssertions().assertTextPresent(locator, info.getDescription());
        }
        boolean isFavourite = new XPathLocator(this.tester, "//a[starts-with(@id, 'fav_a_nav_SearchRequest_') and @title='Remove this filter from your favourites']").exists();
        boolean isNotFavourite = new XPathLocator(this.tester, "//a[starts-with(@id, 'fav_a_nav_SearchRequest_') and @title='Add this filter to your favourites']").exists();
        if (info.isFavourite()) {
            junit.framework.Assert.assertTrue((String)"Should have been favourited but wasn't", (boolean)isFavourite);
            junit.framework.Assert.assertFalse((String)"Should not have been un-favourited but was", (boolean)isNotFavourite);
        } else {
            junit.framework.Assert.assertFalse((String)"Should not have been favourited but wasn", (boolean)isFavourite);
            junit.framework.Assert.assertTrue((String)"Should have been un-favourited but wasn't", (boolean)isNotFavourite);
        }
    }

    @Override
    public void assertSearchResults(Iterable<? extends SearchResultsCondition> conditions) {
        for (SearchResultsCondition searchResultsCondition : conditions) {
            searchResultsCondition.assertCondition(this.tester);
        }
    }

    @Override
    public void assertSearchResults(SearchResultsCondition ... conditions) {
        this.assertSearchResults(Arrays.asList(conditions));
    }

    @Override
    public void assertSearchResultsAreEmpty() {
        this.assertSearchResults((Iterable<? extends SearchResultsCondition>)ImmutableList.of((Object)new NumberOfIssuesCondition(this.getTextAssertions(), 0)));
    }

    @Override
    public void assertExactIssuesInResults(String ... keys) {
        ArrayList<ContainsIssueKeysCondition> conditions = new ArrayList<ContainsIssueKeysCondition>();
        if (keys.length > 0) {
            conditions.add(new ContainsIssueKeysCondition(this.getTextAssertions(), keys));
        }
        this.assertSearchResults(conditions);
    }

    @Override
    public void assertSearchResultsContain(String ... keys) {
        Assertions.notNull(keys);
        Assertions.is(!Iterables.isEmpty(Arrays.asList(keys)));
        this.assertSearchResults((Iterable<? extends SearchResultsCondition>)ImmutableList.of((Object)new ContainsIssueKeysCondition(this.getTextAssertions(), keys)));
    }

    @Override
    public void assertSearchResultsDoNotContain(String ... keys) {
        Assertions.notNull(keys);
        Assertions.is(!Iterables.isEmpty(Arrays.asList(keys)));
        this.assertSearchResults(Iterables.transform(Arrays.asList(keys), (Function)new Function<String, SearchResultsCondition>(){

            public SearchResultsCondition apply(@Nullable String input) {
                return new DoesNotContainIssueKeyCondition(IssueNavigatorAssertionsImpl.this.getTextAssertions(), input);
            }
        }));
    }

    @Override
    public void assertJqlErrors(String ... errorMessages) {
        this.getTextAssertions().assertTextSequence(new IdLocator(this.tester, "jqlerror"), errorMessages);
    }

    @Override
    public void assertJqlWarnings(String ... warningMessages) {
        this.getTextAssertions().assertTextSequence(new IdLocator(this.tester, "jqlwarning"), warningMessages);
    }

    @Override
    public void assertJqlTooComplex() {
        junit.framework.Assert.assertEquals((String)"Should be on the advanced view.", (Object)((Object)IssueNavigatorNavigation.NavigatorEditMode.ADVANCED), (Object)((Object)this.getNavigation().issueNavigator().getCurrentEditMode()));
        IdLocator locator = new IdLocator(this.tester, "filter-switch");
        this.getTextAssertions().assertTextSequence(locator, "This query is too complex to display in Simple mode.", new String[0]);
    }

    @Override
    public void assertNoJqlErrors() {
        junit.framework.Assert.assertEquals((int)0, (int)new IdLocator(this.tester, "jqlerror").getNodes().length);
        junit.framework.Assert.assertEquals((int)0, (int)new IdLocator(this.tester, "jqlwarning").getNodes().length);
    }

    @Override
    public void assertJqlFitsInFilterForm(String jqlQuery, IssueNavigatorAssertions.FilterFormParam ... formParams) {
        this.log("Asserting fits filter: '" + jqlQuery + "' with params: " + Arrays.asList(formParams));
        this.getNavigation().issueNavigator().createSearch(jqlQuery);
        this.getNavigation().issueNavigator().gotoEditMode(IssueNavigatorNavigation.NavigatorEditMode.SIMPLE);
        for (IssueNavigatorAssertions.FilterFormParam formParam : formParams) {
            this.tester.setWorkingForm("issue-filter");
            IssueNavigatorAssertionsImpl.assertSameElements(formParam.getValues(), this.tester.getDialog().getForm().getParameterValues(formParam.getName()));
        }
    }

    private static void assertSameElements(String[] a, String[] b) {
        HashSet<String> as = a == null || a.length == 0 ? null : new HashSet<String>(Arrays.asList(a));
        HashSet<String> bs = b == null || b.length == 0 ? null : new HashSet<String>(Arrays.asList(b));
        junit.framework.Assert.assertEquals(as, (Object)bs);
    }

    @Override
    public void assertIssueNavigatorDisplaying(Locator locator, String from, String to, String of) {
        this.getTextAssertions().assertTextSequence(locator, new String[]{from, "\u2013", to, "of", of});
    }

    protected TextAssertions getTextAssertions() {
        return this.getFuncTestHelperFactory().getTextAssertions();
    }
}

