/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.functest.framework.admin.user;

import com.atlassian.jira.functest.framework.HtmlPage;
import com.atlassian.jira.functest.framework.locator.CssLocator;
import com.atlassian.jira.functest.framework.page.AbstractWebTestPage;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class DeleteUserPage
extends AbstractWebTestPage {
    public static final Pattern SHARED_FILTERS = Pattern.compile("(.*)Shared Filter:(.*)");
    public static final Pattern FAVORITED_FILTERS = Pattern.compile("(.*)Favourited Filter:(.*)");
    public static final Pattern SHARED_DASHBOARDS = Pattern.compile("(.*)Shared Dashboard:(.*)");
    public static final Pattern FAVORITED_DASHBOARDS = Pattern.compile("(.*)Favourited Dashboard:(.*)");
    public static final Pattern ASSIGNED_ISSUES = Pattern.compile("(.*)Assigned Issue:(.*)");
    public static final Pattern REPORTED_ISSUES = Pattern.compile("(.*)Reported Issue:(.*)");
    public static final String USER_CANNOT_DELETE_SYSADMIN = "As a user with JIRA Administrators permission, you cannot delete users with JIRA System Administrators permission.";
    public static final String USER_CANNOT_DELETE_SELF = "You cannot delete the currently logged in user.";
    private final String DELETE_USER_BASE_URL = "/secure/admin/user/DeleteUser!default.jspa";
    private final Pattern DIGIT_PATTERN = Pattern.compile("\\d+");

    public String getUserCannotBeDeleteMessage(String user) {
        return "Cannot delete user. '" + user + "' has associations in JIRA that cannot be removed automatically.";
    }

    public DeleteUserPage clickDeleteUser() {
        this.funcTestHelperFactory.getTester().submit("Delete");
        return this;
    }

    public static String generateDeleteQueryParameters(String user) {
        return "returnUrl=UserBrowser.jspa&name=" + user;
    }

    public static String generateDeleteQueryParametersWithXsrf(String user, HtmlPage page) {
        return page.addXsrfToken("?returnUrl=UserBrowser.jspa&name=" + user).replace("?", "");
    }

    public DeleteUserPage confirmNoDeleteButtonPresent() {
        this.funcTestHelperFactory.getTester().assertSubmitButtonNotPresent("Delete");
        return this;
    }

    public String getNumberForPluginErrorNamed(Pattern errorPattern) {
        return this.getTextPrefixForSelector(errorPattern, ".user-errors a");
    }

    public String getUserDeletionError() {
        return this.getCssFieldText("#user-cannot-be-deleted");
    }

    public String getUserDeleteSelfError() {
        return this.getCssFieldText("#user-delete-self-error");
    }

    public String getNonAdminDeletingSysAdminErrorMessage() {
        return this.getCssFieldText("#user-nonadmin-error");
    }

    public String getNumberFromErrorFieldNamed(Pattern errorPattern) {
        return this.getTextPrefixForSelector(errorPattern, ".user-errors a");
    }

    public String getNumberFromWarningFieldNamed(Pattern warningPattern) {
        return this.getTextPrefixForSelector(warningPattern, ".user-warnings a");
    }

    public String getNumberFromWarningFieldNamedNoLink(Pattern warningPattern) {
        return this.getTextPrefixForSelector(warningPattern, ".user-warnings span");
    }

    public CssLocator getProjectLink() {
        return this.funcTestHelperFactory.getLocator().css("#user-projects-summary a");
    }

    public CssLocator getComponentLink() {
        return this.funcTestHelperFactory.getLocator().css("#user-components-summary a");
    }

    private String getTextPrefixForSelector(Pattern elemToMatch, String cssSelector) {
        CssLocator selectedCss = this.funcTestHelperFactory.getLocator().css(cssSelector);
        String prefixNumber = "0";
        for (Node node : selectedCss.getNodes()) {
            Matcher m;
            NodeList children = node.getChildNodes();
            String elemTextContents = children.item(0).getNodeValue();
            if (!elemToMatch.matcher(elemTextContents).matches() || !(m = this.DIGIT_PATTERN.matcher(elemTextContents)).find()) continue;
            prefixNumber = m.group(0);
        }
        return prefixNumber;
    }

    private String getCssFieldText(String cssSelector) {
        CssLocator css = this.funcTestHelperFactory.getLocator().css(cssSelector);
        if (css.getNodes().length > 0) {
            return css.getNodes()[0].getNodeValue();
        }
        return "";
    }

    @Override
    public String baseUrl() {
        return "/secure/admin/user/DeleteUser!default.jspa";
    }
}

