/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.functest.framework.admin.plugins;

import com.atlassian.jira.functest.framework.AbstractFuncTestUtil;
import com.atlassian.jira.functest.framework.Administration;
import com.atlassian.jira.functest.framework.LocatorFactory;
import com.atlassian.jira.functest.framework.Navigation;
import com.atlassian.jira.functest.framework.admin.plugins.Plugins;
import com.atlassian.jira.functest.framework.admin.plugins.ReferenceDependentPlugin;
import com.atlassian.jira.functest.framework.admin.plugins.ReferenceLanguagePack;
import com.atlassian.jira.functest.framework.admin.plugins.ReferencePlugin;
import com.atlassian.jira.util.json.JSONException;
import com.atlassian.jira.util.json.JSONObject;
import com.atlassian.jira.webtests.util.JIRAEnvironmentData;
import com.meterware.httpunit.GetMethodWebRequest;
import com.meterware.httpunit.HttpUnitOptions;
import com.meterware.httpunit.PutMethodWebRequest;
import com.meterware.httpunit.WebRequest;
import com.meterware.httpunit.WebResponse;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Collections;
import java.util.Map;
import junit.framework.Assert;
import net.sourceforge.jwebunit.WebTester;
import org.apache.commons.lang.StringUtils;
import org.xml.sax.SAXException;

public class PluginsImpl
extends AbstractFuncTestUtil
implements Plugins {
    private final Navigation navigation;
    private final Administration administration;
    private final ReferencePlugin referencePlugin;
    private final ReferenceDependentPlugin referenceDependentPlugin;
    private final ReferenceLanguagePack referenceLanguagePack;

    public PluginsImpl(WebTester tester, JIRAEnvironmentData environmentData, int logIndentLevel, Navigation navigation, Administration administration, LocatorFactory locators) {
        super(tester, environmentData, logIndentLevel);
        this.navigation = navigation;
        this.administration = administration;
        this.referencePlugin = new ReferencePlugin(tester, administration, locators, navigation);
        this.referenceDependentPlugin = new ReferenceDependentPlugin(tester, administration, locators);
        this.referenceLanguagePack = new ReferenceLanguagePack(administration);
    }

    @Override
    public boolean isPluginInstalled(String pluginKey) {
        try {
            String currentPage = this.navigation.getCurrentPage();
            this.navigation.gotoAdmin();
            boolean found = this.findPlugin(pluginKey) != null;
            this.navigation.gotoPage(currentPage);
            return found;
        }
        catch (Exception e) {
            throw new RuntimeException("Plugin utility failed", e);
        }
    }

    @Override
    public ReferencePlugin referencePlugin() {
        return this.referencePlugin;
    }

    @Override
    public ReferenceDependentPlugin referenceDependentPlugin() {
        return this.referenceDependentPlugin;
    }

    @Override
    public ReferenceLanguagePack referenceLanguagePack() {
        return this.referenceLanguagePack;
    }

    @Override
    public void disablePlugin(String pluginKey) {
        this.togglePlugin(pluginKey, false);
    }

    @Override
    public void enablePlugin(String pluginKey) {
        this.togglePlugin(pluginKey, true);
    }

    @Override
    public void disablePluginModule(String pluginKey, String completeModuleKey) {
        this.togglePluginModule(pluginKey, completeModuleKey, false);
    }

    @Override
    public void enablePluginModule(String pluginKey, String completeModuleKey) {
        this.togglePluginModule(pluginKey, completeModuleKey, true);
    }

    @Override
    public boolean canDisablePluginModule(String pluginKey, String completeModuleKey) {
        try {
            String currentPage = this.navigation.getCurrentPage();
            JSONObject plugin = this.findPlugin(pluginKey);
            plugin = this.fetchFullObjectInfo(plugin);
            JSONObject module = this.findModule(plugin, completeModuleKey);
            this.navigation.gotoPage(currentPage);
            return module.getBoolean("optional");
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public boolean canDisablePlugin(String pluginKey) {
        try {
            String currentPage = this.navigation.getCurrentPage();
            String contentType = this.tester.getDialog().getWebClient().getCurrentPage().getHeaderField("CONTENT-TYPE");
            JSONObject plugin = this.findPlugin(pluginKey);
            plugin = this.fetchFullObjectInfo(plugin);
            this.navigation.gotoPage(currentPage);
            return plugin.getBoolean("optional");
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public boolean isPluginEnabled(String pluginKey) {
        try {
            String contentType = this.tester.getDialog().getWebClient().getCurrentPage().getHeaderField("CONTENT-TYPE");
            JSONObject plugin = this.findPlugin(pluginKey);
            plugin = this.fetchFullObjectInfo(plugin);
            this.navigation.gotoPage(this.navigation.getCurrentPage());
            return plugin.getBoolean("enabled");
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public boolean isPluginDisabled(String pluginKey) {
        return !this.isPluginEnabled(pluginKey);
    }

    @Override
    public boolean isPluginModuleEnabled(String pluginKey, String completeModuleKey) {
        try {
            String currentPage = this.navigation.getCurrentPage();
            this.navigation.gotoAdmin();
            JSONObject plugin = this.findPlugin(pluginKey);
            plugin = this.fetchFullObjectInfo(plugin);
            JSONObject module = this.findModule(plugin, completeModuleKey);
            this.navigation.gotoPage(currentPage);
            return module.getBoolean("enabled");
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public boolean isPluginModuleDisabled(String pluginKey, String completeModuleKey) {
        return !this.isPluginModuleEnabled(pluginKey, completeModuleKey);
    }

    private void togglePlugin(String pluginKey, boolean enabled) {
        try {
            String currentPage = this.navigation.getCurrentPage();
            this.navigation.gotoAdmin();
            JSONObject plugin = this.findPlugin(pluginKey);
            if (plugin == null) {
                throw new IllegalStateException(pluginKey + " plugin can not be found! Is it installed?");
            }
            plugin = this.fetchFullObjectInfo(plugin);
            plugin.put("enabled", enabled);
            this.sendObject(plugin, "application/vnd.atl.plugins.plugin+json");
            this.navigation.gotoPage(currentPage);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private void togglePluginModule(String pluginKey, String completeModuleKey, boolean enabled) {
        try {
            String currentPage = this.navigation.getCurrentPage();
            this.navigation.gotoAdmin();
            JSONObject plugin = this.findPlugin(pluginKey);
            if (plugin == null) {
                throw new IllegalStateException(pluginKey + " plugin can not be found! Is it installed?");
            }
            JSONObject module = this.findModule(plugin = this.fetchFullObjectInfo(plugin), completeModuleKey);
            if (module == null) {
                throw new IllegalStateException(completeModuleKey + " module for " + pluginKey + " plugin " + "cannot be found.");
            }
            module = this.fetchFullObjectInfo(module);
            module.put("enabled", enabled);
            this.sendObject(module, "application/vnd.atl.plugins.plugin.module+json");
            this.navigation.gotoPage(currentPage);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private JSONObject findPlugin(String pluginKey) throws Exception {
        WebResponse resp123 = this.GET("/rest/plugins/1.0/");
        Assert.assertEquals((int)200, (int)resp123.getResponseCode());
        JSONObject content = new JSONObject(resp123.getText());
        for (int i = 0; i < content.getJSONArray("plugins").length(); ++i) {
            JSONObject plugin = content.getJSONArray("plugins").getJSONObject(i);
            if (!plugin.getString("key").equals(pluginKey)) continue;
            return plugin;
        }
        return null;
    }

    private JSONObject findModule(JSONObject plugin, String completeModuleKey) {
        try {
            for (int i = 0; i < plugin.getJSONArray("modules").length(); ++i) {
                JSONObject module = plugin.getJSONArray("modules").getJSONObject(i);
                if (!module.getString("completeKey").equals(completeModuleKey)) continue;
                return module;
            }
            return null;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private JSONObject fetchFullObjectInfo(JSONObject object) throws JSONException, IOException, SAXException {
        this.tester.getDialog().getWebClient().setExceptionsThrownOnErrorStatus(false);
        HttpUnitOptions.setExceptionsThrownOnErrorStatus((boolean)false);
        URL sendURL = new URL(this.environmentData.getBaseUrl(), object.getJSONObject("links").getString("self"));
        GetMethodWebRequest request = new GetMethodWebRequest(sendURL.toString());
        WebResponse resp123 = this.tester.getDialog().getWebClient().sendRequest((WebRequest)request);
        Assert.assertEquals((int)200, (int)resp123.getResponseCode());
        return new JSONObject(resp123.getText());
    }

    private void sendObject(JSONObject plugin, String mediaType) throws Exception {
        WebResponse resp123 = this.PUT(plugin.getJSONObject("links").getString("modify"), plugin, mediaType);
        Assert.assertEquals((int)200, (int)resp123.getResponseCode());
    }

    public WebResponse PUT(String url, JSONObject json, String mediaType) throws IOException, SAXException {
        return this.PUT(url, json.toString(), mediaType);
    }

    public WebResponse PUT(String url, String postBody, String mediaType) throws IOException, SAXException {
        this.tester.getDialog().getWebClient().setExceptionsThrownOnErrorStatus(false);
        HttpUnitOptions.setExceptionsThrownOnErrorStatus((boolean)false);
        URL sendURL = new URL(this.environmentData.getBaseUrl(), url);
        PutMethodWebRequest request = new PutMethodWebRequest(sendURL.toString(), (InputStream)new ByteArrayInputStream(postBody.getBytes()), mediaType);
        return this.tester.getDialog().getWebClient().sendRequest((WebRequest)request);
    }

    public WebResponse GET(String url) throws IOException, SAXException {
        return this.GET(url, Collections.emptyMap());
    }

    public WebResponse GET(String url, Map<String, String> headers) throws IOException, SAXException {
        this.tester.getDialog().getWebClient().setExceptionsThrownOnErrorStatus(false);
        HttpUnitOptions.setExceptionsThrownOnErrorStatus((boolean)false);
        for (Map.Entry<String, String> headerField : headers.entrySet()) {
            this.tester.getDialog().getWebClient().setHeaderField(headerField.getKey(), headerField.getValue());
        }
        GetMethodWebRequest request = new GetMethodWebRequest(this.getBaseUrlPlus(url));
        return this.tester.getDialog().getWebClient().sendRequest((WebRequest)request);
    }

    protected String getBaseUrlPlus(String ... paths) {
        String path = paths != null ? StringUtils.join((Object[])paths, (char)'/') : "";
        return String.format("%s/%s", this.environmentData.getBaseUrl(), path);
    }
}

