/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.functest.framework.admin;

import com.atlassian.jira.functest.framework.AbstractFuncTestUtil;
import com.atlassian.jira.functest.framework.Navigation;
import com.atlassian.jira.functest.framework.admin.ViewWorkflows;
import com.atlassian.jira.functest.framework.admin.WorkflowInitialStep;
import com.atlassian.jira.functest.framework.admin.WorkflowInitialStepImpl;
import com.atlassian.jira.functest.framework.admin.WorkflowSteps;
import com.atlassian.jira.functest.framework.admin.WorkflowStepsImpl;
import com.atlassian.jira.functest.framework.admin.workflows.PublishDraftPage;
import com.atlassian.jira.functest.framework.admin.workflows.ViewWorkflowPage;
import com.atlassian.jira.functest.framework.admin.workflows.WorkflowDesignerPage;
import com.atlassian.jira.functest.framework.locator.CssLocator;
import com.atlassian.jira.functest.framework.util.dom.DomKit;
import com.atlassian.jira.util.dbc.Assertions;
import com.atlassian.jira.webtests.util.JIRAEnvironmentData;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMultiset;
import com.google.common.collect.Multiset;
import java.util.List;
import net.sourceforge.jwebunit.WebTester;
import org.w3c.dom.Node;

public class ViewWorkflowsImpl
extends AbstractFuncTestUtil
implements ViewWorkflows {
    private static final String NEW_WORKFLOW_NAME_INPUT_NAME = "newWorkflowName";
    private static final String NEW_WORKFLOW_DESCRIPTION_INPUT_NAME = "description";
    private static final String SUBMIT_BUTTON_NAME = "Add";
    private static final String COPY_BUTTON_NAME = "Update";
    private static final String COPY_LINK_PREFIX = "copy_";
    private static final String STEPS_LINK_PREFIX = "steps_live_";
    private static final String CONFIRM_DELETE_BUTTON_NAME = "Delete";
    private final int logIndentLevel;
    private final Navigation navigation;
    private final WorkflowSteps steps;

    public ViewWorkflowsImpl(WebTester tester, JIRAEnvironmentData environmentData, int logIndentLevel, Navigation navigation) {
        super(tester, environmentData, logIndentLevel);
        this.logIndentLevel = logIndentLevel;
        this.navigation = navigation;
        this.steps = new WorkflowStepsImpl(tester, environmentData, this.childLogIndentLevel());
    }

    @Override
    public ViewWorkflows goTo() {
        this.navigation.gotoWorkflows();
        return this;
    }

    @Override
    public ViewWorkflows addWorkflow(String name, String description) {
        Assertions.notNull("name", name);
        this.tester.clickLink("add-workflow");
        this.tester.setFormElement(NEW_WORKFLOW_NAME_INPUT_NAME, name);
        if (description != null) {
            this.tester.setFormElement(NEW_WORKFLOW_DESCRIPTION_INPUT_NAME, description);
        }
        this.tester.submit(SUBMIT_BUTTON_NAME);
        this.goTo();
        return this;
    }

    @Override
    public WorkflowDesignerPage edit(String workflowName) {
        this.tester.clickLink("edit_live_" + workflowName);
        return this.newDesignerPage();
    }

    @Override
    public ViewWorkflows delete(String name) {
        Assertions.notNull("name", name);
        this.tester.clickLink("del_" + name);
        this.tester.submit(CONFIRM_DELETE_BUTTON_NAME);
        this.goTo();
        return this;
    }

    private WorkflowDesignerPage newDesignerPage() {
        return new WorkflowDesignerPage(this.tester, this.getEnvironmentData(), this.logIndentLevel, this);
    }

    @Override
    public WorkflowSteps createDraft(String name) {
        this.edit(name).textView().goTo();
        return this.steps;
    }

    @Override
    public PublishDraftPage publishDraft(String name) {
        this.edit(name);
        this.tester.clickLink("publish_draft_workflow");
        return new PublishDraftPage(this.tester, this);
    }

    @Override
    public WorkflowDesignerPage copyWorkflow(String nameToCopy, String newWorkflowName) {
        this.tester.clickLink(COPY_LINK_PREFIX + nameToCopy);
        this.tester.setFormElement(NEW_WORKFLOW_NAME_INPUT_NAME, newWorkflowName);
        this.tester.submit(COPY_BUTTON_NAME);
        return this.newDesignerPage();
    }

    @Override
    public WorkflowDesignerPage copyWorkflow(String nameToCopy, String newWorkflowName, String newWorkflowDescription) {
        this.tester.clickLink(COPY_LINK_PREFIX + nameToCopy);
        this.tester.setFormElement(NEW_WORKFLOW_NAME_INPUT_NAME, newWorkflowName);
        this.tester.setFormElement(NEW_WORKFLOW_DESCRIPTION_INPUT_NAME, newWorkflowDescription);
        this.tester.submit(COPY_BUTTON_NAME);
        return this.newDesignerPage();
    }

    @Override
    public WorkflowSteps workflowSteps(String workflowName) {
        this.edit(workflowName).textView().goTo();
        return this.steps;
    }

    @Override
    public ViewWorkflows launchDesigner(String workflowName) {
        this.edit(workflowName);
        this.tester.assertTextPresent("Workflow Designer");
        return this;
    }

    @Override
    public boolean isImportWorkflowFromXmlButtonPresent() {
        return this.locators.id("import-workflow").exists();
    }

    @Override
    public ViewWorkflows.WorkflowItemsList active() {
        CssLocator activeWorkflowsTable = new CssLocator(this.tester, "#active-workflows-table tbody tr");
        if (activeWorkflowsTable.exists() && activeWorkflowsTable.hasNodes()) {
            ImmutableList.Builder results = ImmutableList.builder();
            for (Node node : activeWorkflowsTable.getNodes()) {
                boolean isDraft = new CssLocator(node, "[data-cell-type=name] .icon-draft").exists();
                String name = new CssLocator(node, "[data-cell-type=name] strong").getText();
                String description = new CssLocator(node, "[data-cell-type=name] .secondary-text").getText();
                String lastModified = new CssLocator(node, "[data-cell-type=last-modified]").getText();
                CssLocator schemes = new CssLocator(node, "[data-cell-type=schemes] li");
                ImmutableMultiset.Builder schemeItems = ImmutableMultiset.builder();
                if (schemes.exists() && schemes.hasNodes()) {
                    for (Node scheme : schemes.getNodes()) {
                        schemeItems.add((Object)DomKit.getCollapsedText(scheme));
                    }
                }
                int steps = Integer.parseInt(new CssLocator(node, "[data-cell-type=steps]").getText());
                results.add((Object)new ViewWorkflows.WorkflowItem(name, description, lastModified, (Multiset<String>)schemeItems.build(), steps, isDraft ? ViewWorkflows.WorkflowState.DRAFT : ViewWorkflows.WorkflowState.ACTIVE));
            }
            return new ViewWorkflows.WorkflowItemsList((List<ViewWorkflows.WorkflowItem>)results.build());
        }
        return new ViewWorkflows.WorkflowItemsList((List<ViewWorkflows.WorkflowItem>)ImmutableList.of());
    }

    @Override
    public ViewWorkflows.WorkflowItemsList inactive() {
        CssLocator activeWorkflowsTable = new CssLocator(this.tester, "#inactive-workflows-table tbody tr");
        if (activeWorkflowsTable.exists() && activeWorkflowsTable.hasNodes()) {
            ImmutableList.Builder results = ImmutableList.builder();
            for (Node node : activeWorkflowsTable.getNodes()) {
                boolean isDraft = new CssLocator(node, "[data-cell-type=name] .icon-draft").exists();
                String name = new CssLocator(node, "[data-cell-type=name] strong").getText();
                String description = new CssLocator(node, "[data-cell-type=name] .secondary-text").getText();
                String lastModified = new CssLocator(node, "[data-cell-type=last-modified]").getText();
                CssLocator schemes = new CssLocator(node, "[data-cell-type=schemes] li");
                ImmutableMultiset.Builder schemeItems = ImmutableMultiset.builder();
                if (schemes.exists() && schemes.hasNodes()) {
                    for (Node scheme : schemes.getNodes()) {
                        schemeItems.add((Object)DomKit.getCollapsedText(scheme));
                    }
                }
                int steps = Integer.parseInt(new CssLocator(node, "[data-cell-type=steps]").getText());
                results.add((Object)new ViewWorkflows.WorkflowItem(name, description, lastModified, (Multiset<String>)schemeItems.build(), steps, isDraft ? ViewWorkflows.WorkflowState.DRAFT : ViewWorkflows.WorkflowState.INACTIVE));
            }
            return new ViewWorkflows.WorkflowItemsList((List<ViewWorkflows.WorkflowItem>)results.build());
        }
        return new ViewWorkflows.WorkflowItemsList((List<ViewWorkflows.WorkflowItem>)ImmutableList.of());
    }

    @Override
    public boolean isEditable(String workflowName) {
        CssLocator activeWorkflowsTable = new CssLocator(this.tester, "#active-workflows-table tbody tr");
        for (Node node : activeWorkflowsTable.getNodes()) {
            String name = new CssLocator(node, "[data-cell-type=name] strong").getText();
            if (!name.equals(workflowName)) continue;
            CssLocator editOperation = new CssLocator(node, "[data-cell-type=operations] [data-operation=edit]");
            return editOperation.exists();
        }
        CssLocator inactiveWorkflowsTable = new CssLocator(this.tester, "#inactive-workflows-table tbody tr");
        for (Node node : inactiveWorkflowsTable.getNodes()) {
            String name = new CssLocator(node, "[data-cell-type=name] strong").getText();
            if (!name.equals(workflowName)) continue;
            CssLocator editOperation = new CssLocator(node, "[data-cell-type=operations] [data-operation=edit]");
            return editOperation.exists();
        }
        throw new IllegalArgumentException(String.format("Unable to find workflow: '%s' in the Workflows Administration page", workflowName));
    }

    @Override
    public ViewWorkflowPage view(String workflowName) {
        this.tester.clickLink(STEPS_LINK_PREFIX + workflowName);
        return new ViewWorkflowPage(this.tester, this.environmentData, this.logIndentLevel);
    }

    @Override
    public WorkflowInitialStep workflowInitialStep(String workflowName) {
        return new WorkflowInitialStepImpl(this.tester, this.getEnvironmentData(), this.childLogIndentLevel(), workflowName);
    }
}

