/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.functest.framework.admin;

import com.atlassian.jira.functest.framework.admin.WorkflowInitialStep;
import com.atlassian.jira.functest.framework.admin.WorkflowSteps;
import com.atlassian.jira.functest.framework.admin.workflows.PublishDraftPage;
import com.atlassian.jira.functest.framework.admin.workflows.ViewWorkflowPage;
import com.atlassian.jira.functest.framework.admin.workflows.WorkflowDesignerPage;
import com.google.common.base.Predicate;
import com.google.common.collect.ForwardingList;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.google.common.collect.Multiset;
import java.util.List;
import javax.annotation.concurrent.Immutable;
import org.apache.commons.lang.builder.EqualsBuilder;
import org.apache.commons.lang.builder.HashCodeBuilder;
import org.apache.commons.lang.builder.ToStringBuilder;

public interface ViewWorkflows {
    public ViewWorkflows goTo();

    public ViewWorkflows addWorkflow(String var1, String var2);

    public WorkflowDesignerPage edit(String var1);

    public ViewWorkflows delete(String var1);

    public WorkflowSteps createDraft(String var1);

    public PublishDraftPage publishDraft(String var1);

    public WorkflowDesignerPage copyWorkflow(String var1, String var2);

    public WorkflowDesignerPage copyWorkflow(String var1, String var2, String var3);

    public WorkflowSteps workflowSteps(String var1);

    @Deprecated
    public ViewWorkflows launchDesigner(String var1);

    public boolean isImportWorkflowFromXmlButtonPresent();

    public WorkflowItemsList active();

    public WorkflowItemsList inactive();

    public boolean isEditable(String var1);

    public ViewWorkflowPage view(String var1);

    public WorkflowInitialStep workflowInitialStep(String var1);

    public static enum WorkflowState {
        ACTIVE,
        DRAFT,
        INACTIVE;

    }

    @Immutable
    public static class WorkflowItem {
        private final String name;
        private final String lastModified;
        private final Multiset<String> schemes;
        private final int steps;
        private final boolean isDraft;
        private final String description;

        public WorkflowItem(String name, String description, String lastModified, Multiset<String> schemes, int steps, WorkflowState state) {
            this.name = name;
            this.description = description;
            this.lastModified = lastModified;
            this.schemes = schemes;
            this.steps = steps;
            this.isDraft = state.equals((Object)WorkflowState.DRAFT);
        }

        public String name() {
            return this.name;
        }

        public String lastModified() {
            return this.lastModified;
        }

        public Multiset<String> schemes() {
            return this.schemes;
        }

        public int steps() {
            return this.steps;
        }

        public boolean isDraft() {
            return this.isDraft;
        }

        public int hashCode() {
            return new HashCodeBuilder().append((Object)this.name()).append(this.isDraft()).toHashCode();
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof WorkflowItem)) {
                return false;
            }
            WorkflowItem rhs = (WorkflowItem)obj;
            return new EqualsBuilder().append((Object)this.name(), (Object)rhs.name()).append(this.isDraft(), rhs.isDraft()).isEquals();
        }

        public String toString() {
            return new ToStringBuilder((Object)this).append("name", (Object)this.name).append("description", (Object)this.description).append("isDraft", this.isDraft()).append("lastModified", (Object)this.lastModified()).append("steps", this.steps()).append("schemes", (Object)Iterables.toString(this.schemes())).toString();
        }

        public String description() {
            return this.description;
        }
    }

    public static class WorkflowItemsList
    extends ForwardingList<WorkflowItem> {
        private List<WorkflowItem> delegate;

        public WorkflowItemsList(List<WorkflowItem> delegate) {
            this.delegate = delegate;
        }

        protected List<WorkflowItem> delegate() {
            return this.delegate;
        }

        public WorkflowItemsList drafts() {
            return new WorkflowItemsList((List<WorkflowItem>)ImmutableList.copyOf((Iterable)Iterables.filter((Iterable)((Object)this), (Predicate)new Predicate<WorkflowItem>(){

                public boolean apply(WorkflowItem input) {
                    return input.isDraft();
                }
            })));
        }

        public boolean contains(final String workflowName) {
            return Iterables.any(this.delegate, (Predicate)new Predicate<WorkflowItem>(){

                public boolean apply(WorkflowItem input) {
                    return input.name().equals(workflowName);
                }
            });
        }

        public static class Predicates {
            public static Predicate<WorkflowItem> byName(String name) {
                return new ByNamePredicate(name);
            }

            public static Predicate<WorkflowItem> byDescription(String description) {
                return new ByDescriptionPredicate(description);
            }

            public static Predicate<WorkflowItem> schemesEqual(final Iterable<String> schemes) {
                return new Predicate<WorkflowItem>(){

                    public boolean apply(WorkflowItem input) {
                        return input.schemes().equals((Object)schemes);
                    }
                };
            }

            private static class ByDescriptionPredicate
            implements Predicate<WorkflowItem> {
                private final String description;

                public ByDescriptionPredicate(String description) {
                    this.description = description;
                }

                public boolean apply(WorkflowItem input) {
                    return input.description().equals(this.description);
                }
            }

            private static class ByNamePredicate
            implements Predicate<WorkflowItem> {
                private final String name;

                public ByNamePredicate(String name) {
                    this.name = name;
                }

                public boolean apply(WorkflowItem input) {
                    return input.name().equals(this.name);
                }
            }
        }
    }
}

