/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.functest.framework.admin;

import com.atlassian.jira.functest.framework.AbstractFuncTestUtil;
import com.atlassian.jira.functest.framework.Navigation;
import com.atlassian.jira.functest.framework.admin.DefaultRoleDetails;
import com.atlassian.jira.functest.framework.admin.RoleDetails;
import com.atlassian.jira.functest.framework.admin.Roles;
import com.atlassian.jira.testkit.client.JIRAEnvironmentData;
import com.atlassian.jira.testkit.client.restclient.Project;
import com.atlassian.jira.testkit.client.restclient.ProjectClient;
import com.atlassian.jira.testkit.client.restclient.ProjectRoleClient;
import com.atlassian.jira.testkit.client.restclient.Response;
import java.util.List;
import junit.framework.Assert;
import net.sourceforge.jwebunit.WebTester;

public class RolesImpl
extends AbstractFuncTestUtil
implements Roles {
    private static final String DELETE_ROLE = "/secure/project/DeleteProjectRole!default.jspa?id=";
    private static final String ADD_ROLE = "/secure/project/UserRoleActorAction!addUsers.jspa?projectRoleId=";
    private RoleDetails roleDetails;

    public RolesImpl(WebTester tester, com.atlassian.jira.webtests.util.JIRAEnvironmentData environmentData, int logIndentLevel) {
        super(tester, environmentData, logIndentLevel);
        this.roleDetails = new DefaultRoleDetails(tester);
    }

    @Override
    public void delete(long roleId) {
        this.log("Deleting project role " + roleId);
        this.tester.gotoPage(DELETE_ROLE + roleId);
        this.tester.submit("Delete");
    }

    @Override
    public void delete(String name) {
        this.log("Deleting project role:" + name);
        this.gotoProjectRolesScreen();
        this.tester.clickLink("delete_" + name);
        this.tester.submit("Delete");
    }

    private void gotoProjectRolesScreen() {
        this.navigation().gotoAdminSection(Navigation.AdminSection.PROJECT_ROLE_BROWSER);
    }

    @Override
    public void create(String name, String description) {
        this.gotoProjectRolesScreen();
        this.tester.setFormElement("name", name);
        this.tester.setFormElement("description", description);
        this.tester.submit("Add Project Role");
        this.tester.assertTextPresent(name);
        this.tester.assertTextPresent(description);
    }

    @Override
    public RoleDetails edit(String name) {
        this.gotoProjectRolesScreen();
        this.tester.clickLink("edit_" + name);
        return this.roleDetails;
    }

    private Project getProjectByName(String projectName) {
        ProjectClient projectClient = new ProjectClient((JIRAEnvironmentData)this.environmentData);
        List projects = projectClient.getProjects();
        for (Project project : projects) {
            if (!project.name.equals(projectName)) continue;
            return project;
        }
        return null;
    }

    private void addUserToProjectRole(String userName, String projectName, String roleName) {
        Project projectByName = this.getProjectByName(projectName);
        if (projectByName == null) {
            Assert.fail((String)("A project with the name '" + projectName + "' does not exist."));
        }
        ProjectRoleClient projectRoleClient = new ProjectRoleClient((JIRAEnvironmentData)this.environmentData);
        Response response = projectRoleClient.addActors(projectByName.key, roleName, null, new String[]{userName});
    }

    @Override
    public void addProjectRoleForUser(String projectName, String roleName, String userName) {
        this.addUserToProjectRole(userName, projectName, roleName);
    }
}

