/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.functest.framework.admin;

import com.atlassian.jira.functest.framework.AbstractFuncTestUtil;
import com.atlassian.jira.functest.framework.Navigation;
import com.atlassian.jira.functest.framework.admin.IssueSecurityLevel;
import com.atlassian.jira.functest.framework.admin.IssueSecurityLevelImpl;
import com.atlassian.jira.functest.framework.admin.IssueSecuritySchemes;
import com.atlassian.jira.webtests.util.JIRAEnvironmentData;
import net.sourceforge.jwebunit.WebTester;

public class IssueSecuritySchemesImpl
extends AbstractFuncTestUtil
implements IssueSecuritySchemes,
IssueSecuritySchemes.IssueSecurityScheme {
    private static final String ADD_SECURITY_SCHEME_LINK_ID = "add_securityscheme";
    private static final String DEL_SECURITY_SCHEME_LINK_ID_FORMAT = "del_%s";
    private static final String FORM_PARAM_NAME = "name";
    private static final String FORM_PARAM_DESC = "description";
    private String currentSchemeName;

    public IssueSecuritySchemesImpl(WebTester tester, JIRAEnvironmentData environmentData) {
        super(tester, environmentData, 2);
    }

    private static String deleteSchemeLinkFor(String schemeName) {
        return String.format(DEL_SECURITY_SCHEME_LINK_ID_FORMAT, schemeName);
    }

    WebTester tester() {
        return this.tester;
    }

    JIRAEnvironmentData envData() {
        return this.environmentData;
    }

    @Override
    public IssueSecuritySchemes.IssueSecurityScheme getScheme(String name) {
        this.gotoIssueSecuritySchemes();
        this.tester.assertLinkPresentWithText(name);
        this.tester.clickLinkWithText(name);
        this.currentSchemeName = name;
        return this;
    }

    @Override
    public IssueSecuritySchemes.IssueSecurityScheme newScheme(String name, String description) {
        this.gotoIssueSecuritySchemes();
        this.tester.clickLink(ADD_SECURITY_SCHEME_LINK_ID);
        this.tester.setFormElement(FORM_PARAM_NAME, name);
        this.tester.setFormElement(FORM_PARAM_DESC, description);
        this.tester.submit("Add");
        return this.getScheme(name);
    }

    @Override
    public IssueSecuritySchemes deleteScheme(String name) {
        this.gotoIssueSecuritySchemes();
        this.tester.clickLink(IssueSecuritySchemesImpl.deleteSchemeLinkFor(name));
        this.tester.submit("Delete");
        this.tester.assertLinkNotPresentWithText(name);
        return this;
    }

    @Override
    public IssueSecurityLevel getLevel(String name) {
        return new IssueSecurityLevelImpl(this, name);
    }

    @Override
    public IssueSecurityLevel newLevel(String name, String description) {
        this.tester.setFormElement(FORM_PARAM_NAME, name);
        this.tester.setFormElement(FORM_PARAM_DESC, description);
        this.tester.submit("Add Security Level");
        this.tester.assertLinkPresent("add_" + name);
        return new IssueSecurityLevelImpl(this, name);
    }

    private void gotoIssueSecuritySchemes() {
        this.getNavigation().gotoAdminSection(Navigation.AdminSection.SECURITY_SCHEMES);
    }

    protected Navigation getNavigation() {
        return this.getFuncTestHelperFactory().getNavigation();
    }
}

