/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.functest.framework.admin;

import com.atlassian.jira.functest.framework.AbstractFuncTestUtil;
import com.atlassian.jira.functest.framework.admin.IssueSecurityLevel;
import com.atlassian.jira.functest.framework.admin.IssueSecuritySchemes;
import com.atlassian.jira.functest.framework.admin.IssueSecuritySchemesImpl;

public class IssueSecurityLevelImpl
extends AbstractFuncTestUtil
implements IssueSecurityLevel {
    private static final String ADD_SECURITY_LINK_ID_FORMAT = "add_%s";
    private final IssueSecuritySchemesImpl schemes;
    private final String name;
    private final String addSecurityLinkId;

    public IssueSecurityLevelImpl(IssueSecuritySchemesImpl schemes, String name) {
        super(schemes.tester(), schemes.envData(), 3);
        this.schemes = schemes;
        this.name = name;
        this.addSecurityLinkId = this.createLinkId();
    }

    private String createLinkId() {
        return String.format(ADD_SECURITY_LINK_ID_FORMAT, this.name);
    }

    @Override
    public IssueSecuritySchemes.IssueSecurityScheme scheme() {
        return this.schemes;
    }

    @Override
    public IssueSecurityLevel addIssueSecurity(IssueSecurityLevel.IssueSecurity issueSecurity) {
        this.tester.clickLink(this.addSecurityLinkId);
        issueSecurity.chooseOnForm(this.tester);
        issueSecurity.submitForm(this.tester);
        return this;
    }

    @Override
    public IssueSecurityLevel addIssueSecurity(IssueSecurityLevel.IssueSecurity issueSecurity, String paramValue) {
        this.tester.clickLink(this.addSecurityLinkId);
        issueSecurity.chooseOnForm(this.tester, paramValue);
        issueSecurity.submitForm(this.tester);
        return this;
    }
}

