/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.functest.framework.admin;

import com.atlassian.jira.functest.framework.AbstractFuncTestUtil;
import com.atlassian.jira.functest.framework.admin.FieldScreenAssociations;
import com.atlassian.jira.functest.framework.locator.XPathLocator;
import com.atlassian.jira.functest.framework.util.text.TextKit;
import com.atlassian.jira.webtests.util.JIRAEnvironmentData;
import com.meterware.httpunit.WebTable;
import java.util.HashMap;
import net.sourceforge.jwebunit.WebTester;
import org.w3c.dom.Node;

public class FieldScreenAssociationsImpl
extends AbstractFuncTestUtil
implements FieldScreenAssociations {
    public FieldScreenAssociationsImpl(WebTester tester, JIRAEnvironmentData environmentData) {
        super(tester, environmentData, 2);
    }

    @Override
    public void removeFieldFromScreen(String screen) {
        this.tester.setWorkingForm("jiraform");
        this.initCheckboxState("associatedScreens");
        this.tester.uncheckCheckbox("associatedScreens", this.getCheckboxValueForScreen(screen));
        this.tester.submit("Update");
    }

    @Override
    public void addFieldToScreen(String screen) {
        this.tester.setWorkingForm("jiraform");
        this.initCheckboxState("associatedScreens");
        this.tester.checkCheckbox("associatedScreens", this.getCheckboxValueForScreen(screen));
        this.tester.submit("Update");
    }

    private void initCheckboxState(String name) {
        XPathLocator checkboxLocator = new XPathLocator(this.tester, String.format("//input[@type='checkbox' and @name='%s']", name));
        Node[] nodes = checkboxLocator.getNodes();
        if (nodes == null || nodes.length == 0) {
            throw new AssertionError((Object)("Could not locate checkboxes with name '" + name + "'"));
        }
        HashMap<String, Boolean> checkboxState = new HashMap<String, Boolean>();
        for (Node node : nodes) {
            String value = node.getAttributes().getNamedItem("value").getNodeValue();
            boolean checked = false;
            Node checkedAttribute = node.getAttributes().getNamedItem("checked");
            if (checkedAttribute != null) {
                checked = "checked".equalsIgnoreCase(checkedAttribute.getNodeValue());
            }
            checkboxState.put(value, checked);
        }
        this.tester.uncheckCheckbox(name);
        for (String value : checkboxState.keySet()) {
            if (!((Boolean)checkboxState.get(value)).booleanValue()) continue;
            this.tester.checkCheckbox(name, value);
        }
    }

    private String getCheckboxValueForScreen(String screen) {
        WebTable screenAssociations = this.tester.getDialog().getWebTableBySummaryOrId("screenAssociations");
        for (int row = 1; row < screenAssociations.getRowCount(); ++row) {
            if (!TextKit.equalsCollapseWhiteSpace(screen, screenAssociations.getCellAsText(row, 0))) continue;
            XPathLocator valueLocator = new XPathLocator(this.tester, String.format("//table[@id='screenAssociations']//tr[%d]/td[3]/input[@type='checkbox']/@value", row));
            Node[] nodes = valueLocator.getNodes();
            if (nodes == null || nodes.length == 0 || nodes.length > 1) {
                throw new AssertionError((Object)"Could not locate checkbox value");
            }
            return nodes[0].getNodeValue();
        }
        throw new AssertionError((Object)("Could not find entry for Screen '" + screen + "'."));
    }
}

