/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.functest.framework.admin;

import com.atlassian.jira.functest.framework.AbstractFuncTestUtil;
import com.atlassian.jira.functest.framework.admin.EditNotifications;
import com.atlassian.jira.functest.framework.admin.NotificationType;
import com.atlassian.jira.functest.framework.util.form.FormParameterUtil;
import com.atlassian.jira.webtests.util.JIRAEnvironmentData;
import net.sourceforge.jwebunit.WebTester;

public class EditNotificationsImpl
extends AbstractFuncTestUtil
implements EditNotifications {
    public EditNotificationsImpl(WebTester tester, JIRAEnvironmentData environmentData, int logIndentLevel) {
        super(tester, environmentData, logIndentLevel);
    }

    @Override
    public int notificationSchemeId() {
        return Integer.parseInt(this.locators.id("notification-scheme-id").getNode().getAttributes().getNamedItem("value").getNodeValue());
    }

    @Override
    public EditNotifications addNotificationsForEvent(int eventId, NotificationType notificationType) {
        this.goAndSelectType(eventId, notificationType);
        this.submitAdd();
        return this;
    }

    @Override
    public EditNotifications addNotificationsForEvent(int eventId, NotificationType notificationType, String paramValue) {
        this.goAndSelectType(eventId, notificationType);
        if (notificationType == NotificationType.GROUP) {
            FormParameterUtil formParameterUtil = new FormParameterUtil(this.tester, "jiraform", "Add");
            formParameterUtil.addOptionToHtmlSelect(notificationType.uiCode(), new String[]{paramValue});
            formParameterUtil.setFormElement(notificationType.uiCode(), paramValue);
            formParameterUtil.submitForm();
            this.tester.clickLinkWithText("Cancel");
        } else {
            this.tester.setFormElement(notificationType.uiCode(), paramValue);
            this.submitAdd();
        }
        return this;
    }

    private void goAndSelectType(int eventId, NotificationType notificationType) {
        this.tester.clickLink("add_" + eventId);
        this.tester.setWorkingForm("jiraform");
        this.tester.checkRadioOption("type", notificationType.uiCode());
    }

    private void submitAdd() {
        this.tester.submit("Add");
    }
}

