/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.functest.framework.admin;

import com.atlassian.jira.functest.framework.admin.EditPopServerConfiguration;
import com.atlassian.jira.functest.framework.admin.MailServerAdministration;
import net.sourceforge.jwebunit.WebTester;
import org.apache.commons.lang.StringUtils;

public class DefaultEditPopServerConfiguration
implements EditPopServerConfiguration {
    private final WebTester tester;
    private final MailServerAdministration parent;

    public DefaultEditPopServerConfiguration(MailServerAdministration parent, WebTester tester) {
        this.tester = tester;
        this.parent = parent;
    }

    @Override
    public EditPopServerConfiguration setName(String name) {
        this.tester.setFormElement("name", name);
        return this;
    }

    @Override
    public EditPopServerConfiguration setDescription(String description) {
        this.tester.setFormElement("description", description);
        return this;
    }

    @Override
    public EditPopServerConfiguration setProtocol(String protocol) {
        this.tester.selectOption("protocol", protocol);
        return this;
    }

    @Override
    public EditPopServerConfiguration setHostName(String hostName) {
        this.tester.setFormElement("serverName", hostName);
        return this;
    }

    @Override
    public EditPopServerConfiguration setPort(String portNumber) {
        this.tester.setFormElement("port", portNumber);
        return this;
    }

    @Override
    public EditPopServerConfiguration setTimeout(String timeout) {
        this.tester.setFormElement("timeout", timeout);
        return this;
    }

    @Override
    public EditPopServerConfiguration setUserName(String userName) {
        this.tester.setFormElement("username", userName);
        return this;
    }

    @Override
    public EditPopServerConfiguration setPassword(String password) {
        this.tester.setFormElement("password", password);
        return this;
    }

    @Override
    public MailServerAdministration update() throws PasswordIsMandatoryException {
        if (StringUtils.isBlank((String)this.tester.getDialog().getFormParameterValue("password"))) {
            throw new PasswordIsMandatoryException("You need to set a password to update a pop server configuration.");
        }
        this.tester.submit("Update");
        return this.parent;
    }

    public class PasswordIsMandatoryException
    extends Exception {
        public PasswordIsMandatoryException(String message) {
            super(message);
        }
    }
}

