/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.functest.framework.admin;

import com.atlassian.jira.functest.framework.AbstractFuncTestUtil;
import com.atlassian.jira.functest.framework.Navigation;
import com.atlassian.jira.functest.framework.admin.AdvancedApplicationProperties;
import com.atlassian.jira.util.json.JSONArray;
import com.atlassian.jira.util.json.JSONObject;
import com.atlassian.jira.webtests.util.JIRAEnvironmentData;
import com.meterware.httpunit.GetMethodWebRequest;
import com.meterware.httpunit.HttpUnitOptions;
import com.meterware.httpunit.PutMethodWebRequest;
import com.meterware.httpunit.WebRequest;
import com.meterware.httpunit.WebResponse;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import junit.framework.Assert;
import net.sourceforge.jwebunit.WebTester;

public class AdvancedApplicationPropertiesImpl
extends AbstractFuncTestUtil
implements AdvancedApplicationProperties {
    private static final String REST_URL = "/rest/api/2/application-properties/";
    public static final String MEDIA_TYPE = "application/json";

    public AdvancedApplicationPropertiesImpl(WebTester tester, JIRAEnvironmentData environmentData) {
        super(tester, environmentData, 2);
    }

    @Override
    public Map<String, String> getApplicationProperties() {
        try {
            HashMap<String, String> properties = new HashMap<String, String>();
            this.disableErrorChecking();
            GetMethodWebRequest request = new GetMethodWebRequest(this.getAppPropertiesRestUrl().toString());
            WebResponse resp123 = this.tester.getDialog().getWebClient().sendRequest((WebRequest)request);
            Assert.assertEquals((int)200, (int)resp123.getResponseCode());
            JSONArray content = new JSONArray(resp123.getText());
            for (int i = 0; i < content.length(); ++i) {
                JSONObject appProperty = content.getJSONObject(i);
                properties.put(appProperty.getString("key"), appProperty.getString("value"));
            }
            return properties;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void setApplicationProperty(String key, String value) {
        Assert.assertNotNull((Object)this.getApplicationProperty(key));
        Assert.assertNotNull((Object)value);
        try {
            URL sendURL = new URL(this.getAppPropertiesRestUrl(), key);
            this.disableErrorChecking();
            PutMethodWebRequest request = new PutMethodWebRequest(sendURL.toString(), (InputStream)new ByteArrayInputStream(this.getJsonString(key, value).getBytes()), MEDIA_TYPE);
            this.tester.getDialog().getWebClient().sendRequest((WebRequest)request);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public String getApplicationProperty(String key) {
        Map<String, String> properties = this.getApplicationProperties();
        return properties.get(key);
    }

    private String getJsonString(String key, String value) {
        StringBuilder jsonBuilder = new StringBuilder("{\"id\":\"");
        jsonBuilder.append(key).append("\",\"value\":\"").append(value).append("\"}");
        return jsonBuilder.toString();
    }

    private void disableErrorChecking() {
        this.tester.getDialog().getWebClient().setExceptionsThrownOnErrorStatus(false);
        HttpUnitOptions.setExceptionsThrownOnErrorStatus((boolean)false);
    }

    private Navigation getNavigation() {
        return this.getFuncTestHelperFactory().getNavigation();
    }

    private void goToAdvancedSettings() {
        this.getNavigation().gotoAdminSection(Navigation.AdminSection.GENERAL_CONFIGURATION);
        this.tester.clickLink("edit-advanced-properties");
    }

    private URL getAppPropertiesRestUrl() {
        try {
            return new URL(this.environmentData.getBaseUrl().toString() + REST_URL);
        }
        catch (MalformedURLException e) {
            throw new RuntimeException(e);
        }
    }
}

