/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.functest.framework;

import com.atlassian.jira.functest.framework.AbstractFuncTestUtil;
import com.atlassian.jira.functest.framework.Dashboard;
import com.atlassian.jira.functest.framework.DashboardImpl;
import com.atlassian.jira.functest.framework.FilterPickerPopupNavigation;
import com.atlassian.jira.functest.framework.HtmlPage;
import com.atlassian.jira.functest.framework.Navigation;
import com.atlassian.jira.functest.framework.UserProfile;
import com.atlassian.jira.functest.framework.UserProfileImpl;
import com.atlassian.jira.functest.framework.Workflows;
import com.atlassian.jira.functest.framework.WorkflowsImpl;
import com.atlassian.jira.functest.framework.backdoor.Backdoor;
import com.atlassian.jira.functest.framework.navigation.FilterNavigation;
import com.atlassian.jira.functest.framework.navigation.IssueNavigation;
import com.atlassian.jira.functest.framework.navigation.IssueNavigationImpl;
import com.atlassian.jira.functest.framework.navigation.IssueNavigatorNavigation;
import com.atlassian.jira.functest.framework.navigation.IssueNavigatorNavigationImpl;
import com.atlassian.jira.functest.framework.navigation.ManageFiltersNavigation;
import com.atlassian.jira.functest.framework.page.WebTestPage;
import com.atlassian.jira.functest.framework.util.url.URLUtil;
import com.atlassian.jira.testkit.client.log.FuncTestLogger;
import com.atlassian.jira.webtests.util.JIRAEnvironmentData;
import com.meterware.httpunit.HTMLElement;
import com.meterware.httpunit.WebLink;
import com.meterware.httpunit.WebTable;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.net.URL;
import junit.framework.Assert;
import net.sourceforge.jwebunit.WebTester;
import org.apache.commons.lang.StringUtils;
import org.xml.sax.SAXException;

public class NavigationImpl
extends AbstractFuncTestUtil
implements Navigation,
FuncTestLogger {
    public static final String BUTTON_NEXT = "Next";
    public static final String PROJECT_PLUGIN_PREFIX = "com.atlassian.jira.jira-projects-plugin:";
    private static final String PAGE_CUSTOM_FIELDS = "/secure/admin/ViewCustomFields.jspa";
    private static final String PAGE_LIST_WORKFLOWS = "/secure/admin/workflows/ListWorkflows.jspa";
    private static final String ADMIN_LINK_CLASSIC_HEADER = "admin_link";
    private final FilterNavigation manageFiltersNavigation;
    private final IssueNavigation issue;
    private final IssueNavigatorNavigation issueNavigator;
    private final Dashboard dashboard;
    private final FilterNavigation filterPickerPopup;
    private final UserProfile userProfile;
    private final HtmlPage page;
    private final Backdoor backdoor;
    private final Workflows workflows;
    private String lastPasswordUsed;

    public NavigationImpl(WebTester tester, JIRAEnvironmentData environmentData) {
        super(tester, environmentData, 2);
        this.manageFiltersNavigation = new ManageFiltersNavigation(tester, environmentData);
        this.filterPickerPopup = new FilterPickerPopupNavigation(tester);
        this.issue = new IssueNavigationImpl(tester, environmentData);
        this.issueNavigator = new IssueNavigatorNavigationImpl(tester, environmentData);
        this.dashboard = new DashboardImpl(tester, environmentData, this);
        this.userProfile = new UserProfileImpl(tester, environmentData, this);
        this.page = new HtmlPage(tester);
        this.workflows = new WorkflowsImpl(tester, environmentData, this);
        this.backdoor = new Backdoor(environmentData);
    }

    @Override
    public void login(String userName) {
        this.login(userName, userName);
    }

    @Override
    public void login(String userName, String userPassword) {
        this.login(userName, userPassword, false);
    }

    @Override
    public void loginAttempt(String userName, String userPassword) {
        this.loginUsingForm(userName, userPassword, false, false);
    }

    @Override
    public void login(String userName, String userPassword, boolean useCookie) {
        this.doLogin(userName, userPassword, useCookie, true);
    }

    public void doLogin(String userName, String userPassword, boolean useCookie, boolean assertSuccess) {
        if (assertSuccess) {
            this.loginUsingForm(userName, userPassword, useCookie, assertSuccess);
        } else {
            this.loginUsingURLParameters(userName, userPassword, useCookie);
        }
    }

    @Override
    public void loginUsingForm(String userName, String userPassword) {
        this.loginUsingForm(userName, userPassword, false, false);
    }

    @Override
    public void loginUsingForm(String userName, String userPassword, boolean useCookie, boolean assertSuccess) {
        this.log("Logging in as '" + userName + "'");
        this.gotoDashboard();
        this.tester.beginAt("/login.jsp");
        this.tester.setFormElement("os_username", userName);
        this.tester.setFormElement("os_password", userPassword);
        if (useCookie) {
            this.tester.checkCheckbox("os_cookie", "true");
        }
        this.tester.setWorkingForm("login-form");
        this.tester.submit();
        if (assertSuccess) {
            this.assertLoginSuccess(userName);
        }
        this.lastPasswordUsed = userPassword;
    }

    @Override
    public void loginUsingURLParameters(String userName, String userPassword, boolean useCookie) {
        this.log("Logging in as '" + userName + "'");
        String dashboardWithLoginParamsURL = "secure/Dashboard.jspa?os_username=" + URLUtil.encode(userName) + "&os_password=" + URLUtil.encode(userPassword);
        if (useCookie) {
            dashboardWithLoginParamsURL = dashboardWithLoginParamsURL + "&os_cookie=true";
        }
        this.tester.gotoPage(dashboardWithLoginParamsURL);
        this.lastPasswordUsed = userPassword;
    }

    private void assertLoginSuccess(String userName) {
        if (this.tester.getDialog().isTextInResponse("login-form-submit")) {
            Assert.fail((String)("User '" + userName + "' failed to login."));
        }
    }

    @Override
    public void logout() {
        String token;
        try {
            token = this.page.getXsrfToken();
        }
        catch (Exception e) {
            token = "";
        }
        if (StringUtils.isBlank((String)token)) {
            this.tester.gotoPage("/secure/ViewKeyboardShortcuts.jspa");
            token = this.page.getXsrfToken();
        }
        this.log("Logging out");
        this.tester.beginAt("/secure/Logout!default.jspa?atl_token=" + token);
        if (this.tester.getDialog().isTextInResponse("Confirm logout")) {
            this.tester.setWorkingForm("confirm-logout");
            this.tester.clickButton("confirm-logout-submit");
        }
    }

    @Override
    public String getCurrentPage() {
        String urlString = this.tester.getDialog().getResponse().getURL().toString();
        String ctx = this.environmentData.getContext();
        if (ctx.length() > 0) {
            return urlString.substring(urlString.indexOf(ctx) + ctx.length());
        }
        String base = this.environmentData.getBaseUrl().toString();
        return urlString.substring(base.length());
    }

    @Override
    public void clickLink(WebLink webLink) {
        String url = webLink.getURLString();
        if (!url.startsWith("/")) {
            url = this.makeAbsoluteUrl(url, this.tester.getDialog().getResponse().getURL());
        }
        if (url.startsWith(this.getEnvironmentData().getContext())) {
            url = url.substring(this.getEnvironmentData().getContext().length());
        }
        this.tester.gotoPage(url);
    }

    @Override
    public void clickLinkWithExactText(String text) {
        WebLink link = this.page.getLinksWithExactText(text)[0];
        this.clickLink(link);
    }

    @Override
    public void clickLinkInTableCell(WebTable table, int row, int col, String linkText) {
        WebLink webLink = table.getTableCell(row, col).getLinkWith(linkText);
        this.clickLink(webLink);
    }

    @Override
    public void clickLinkInTableCell(String tableId, int row, int col, String linkText) {
        this.clickLinkInTableCell(this.tester.getDialog().getWebTableBySummaryOrId(tableId), row, col, linkText);
    }

    @Override
    public void jiraLog(String logMessage) {
        this.backdoor.getTestkit().logControl().info(logMessage);
    }

    @Override
    public void gotoDashboard() {
        this.dashboard.navigateTo();
    }

    @Override
    public Dashboard dashboard() {
        return this.dashboard;
    }

    @Override
    public Workflows workflows() {
        return this.workflows;
    }

    @Override
    public void clickOnNext() {
        this.tester.submit(BUTTON_NEXT);
    }

    @Override
    public void gotoAdmin() {
        if (this.tester.getDialog().getResponse().getContentType().equals("text/html")) {
            HTMLElement element = null;
            try {
                element = this.tester.getDialog().getResponse().getElementWithID("adminMenu");
            }
            catch (SAXException e) {
                this.log("problem trying to find admin menu div, mustn't be on the admin menu");
            }
            if (element == null) {
                if (this.tester.getDialog().isLinkPresent(ADMIN_LINK_CLASSIC_HEADER)) {
                    this.log("going to admin page via link");
                    this.tester.clickLink(ADMIN_LINK_CLASSIC_HEADER);
                } else {
                    this.log("going to admin page via URL");
                    this.tester.gotoPage("/secure/project/ViewProjects.jspa");
                }
            }
        } else {
            this.log("going to admin page via URL");
            this.tester.gotoPage("/secure/project/ViewProjects.jspa");
        }
    }

    @Override
    public void webSudoAuthenticate(String password) {
        if (this.locators.id("login-notyou").exists()) {
            this.tester.setFormElement("webSudoPassword", password);
            this.tester.setWorkingForm("login-form");
            this.tester.submit();
        }
    }

    @Override
    public void webSudoAuthenticateUsingLastPassword() {
        this.webSudoAuthenticate(this.lastPasswordUsed != null ? this.lastPasswordUsed : "admin");
    }

    @Override
    public void disableWebSudo() {
    }

    @Override
    public void gotoPage(String url) {
        this.tester.gotoPage(url);
    }

    @Override
    public <T extends WebTestPage> T gotoPage(Class<T> pageClass) {
        WebTestPage pageObject = (WebTestPage)this.constructDefault(pageClass);
        pageObject.setContext(this.getFuncTestHelperFactory());
        this.gotoPage(pageObject.baseUrl());
        return (T)pageObject;
    }

    @Override
    public <T extends WebTestPage> T gotoPageWithParams(Class<T> pageClass, String params) {
        WebTestPage pageObject = (WebTestPage)this.constructDefault(pageClass);
        pageObject.setContext(this.getFuncTestHelperFactory());
        this.gotoPage(pageObject.baseUrl() + "?" + params);
        return (T)pageObject;
    }

    private <T> T constructDefault(Class<T> pageClass) {
        Class[] params = new Class[]{};
        try {
            Constructor<T> constructor = pageClass.getConstructor(params);
            return constructor.newInstance(new Object[0]);
        }
        catch (NoSuchMethodException e) {
            throw new RuntimeException(e);
        }
        catch (InvocationTargetException e) {
            throw new RuntimeException(e);
        }
        catch (InstantiationException e) {
            throw new RuntimeException(e);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void gotoResource(String resourcePath) {
        if (resourcePath.startsWith("/")) {
            resourcePath = resourcePath.substring(1);
        }
        if ((resourcePath = this.makeAbsoluteUrl(resourcePath, this.tester.getDialog().getResponse().getURL())).startsWith(this.getEnvironmentData().getContext())) {
            resourcePath = resourcePath.substring(this.getEnvironmentData().getContext().length());
        }
        this.tester.gotoPage(resourcePath);
    }

    @Override
    public void gotoAdminSection(Navigation.AdminSection section) {
        this.tester.gotoPage(section.getUrl());
    }

    @Override
    public void gotoCustomFields() {
        this.tester.gotoPage(PAGE_CUSTOM_FIELDS);
    }

    @Override
    public void gotoWorkflows() {
        this.tester.gotoPage(PAGE_LIST_WORKFLOWS);
    }

    @Override
    public void runReport(Long projectId, String reportKey) {
        this.tester.gotoPage("/secure/ConfigureReport!default.jspa?selectedProjectId=" + projectId + "&reportKey=" + reportKey);
    }

    @Override
    public void runReport(Long projectId, String reportKey, Long filterId, String mapper) {
        this.tester.gotoPage("/secure/ConfigureReport.jspa?selectedProjectId=" + projectId + "&reportKey=" + reportKey + "&filterid=" + filterId + "&mapper=" + mapper);
    }

    @Override
    public void browseProject(String projectKey) {
        this.tester.gotoPage("/browse/" + projectKey);
    }

    @Override
    public void browseProjectTabPanel(String projectKey, String tab) {
        this.browseProject(projectKey);
        this.clickLinkOrAssertSpanPresent(tab);
    }

    @Override
    public void browseComponentTabPanel(String projectKey, String componentName, String tab) {
        this.browseProjectTabPanel(projectKey, "com.atlassian.jira.jira-projects-plugin:components-panel-panel");
        this.tester.clickLinkWithText(componentName);
        this.clickLinkOrAssertSpanPresent(tab);
    }

    @Override
    public void browseVersionTabPanel(String projectKey, String versionName, String tab) {
        this.browseProjectTabPanel(projectKey, "com.atlassian.jira.jira-projects-plugin:versions-panel-panel");
        this.tester.clickLinkWithText(versionName);
        this.clickLinkOrAssertSpanPresent(tab);
    }

    @Override
    public void browseComponentTabPanel(String projectKey, String componentName) {
        this.browseProjectTabPanel(projectKey, "com.atlassian.jira.jira-projects-plugin:components-panel-panel");
        this.tester.clickLinkWithText(componentName);
    }

    @Override
    public void browseVersionTabPanel(String projectKey, String versionName) {
        this.browseProjectTabPanel(projectKey, "com.atlassian.jira.jira-projects-plugin:versions-panel-panel");
        this.tester.clickLinkWithText(versionName);
    }

    private void clickLinkOrAssertSpanPresent(String linkId) {
        WebLink linkElement = null;
        try {
            linkElement = this.tester.getDialog().getResponse().getLinkWithID(linkId);
        }
        catch (SAXException e) {
            this.log("Can't find link with id: " + linkId + ", might already be on that tab panel");
        }
        if (linkElement != null) {
            this.tester.clickLink(linkId);
        } else {
            HTMLElement spanElement = null;
            try {
                spanElement = this.tester.getDialog().getResponse().getElementWithID(linkId);
            }
            catch (SAXException e) {
                this.log("Can't find span with id: " + linkId + ", this is bad.");
            }
            if (spanElement == null) {
                throw new IllegalStateException("Could not browse to project tab panel with link id '" + linkId + "' - tab did not exist.");
            }
        }
    }

    @Override
    public FilterNavigation manageFilters() {
        return this.manageFiltersNavigation;
    }

    @Override
    public FilterNavigation filterPickerPopup() {
        return this.filterPickerPopup;
    }

    @Override
    public UserProfile userProfile() {
        return this.userProfile;
    }

    @Override
    public IssueNavigation issue() {
        return this.issue;
    }

    @Override
    public void gotoFullContentView(String jql) {
        this.gotoPage("/sr/jira.issueviews:searchrequest-fullcontent/temp/SearchRequest.html?tempMax=10000&jqlQuery=" + jql);
    }

    @Override
    public void gotoXmlView(String jql) {
        this.gotoPage("/sr/jira.issueviews:searchrequest-xml/temp/SearchRequest.xml?tempMax=10000&jqlQuery=" + jql);
    }

    @Override
    public IssueNavigatorNavigation issueNavigator() {
        return this.issueNavigator;
    }

    private String makeAbsoluteUrl(String relativeUrl, URL currentPage) {
        String path = currentPage.getPath();
        int pos = path.lastIndexOf(47);
        path = path.substring(0, pos + 1);
        return path + relativeUrl;
    }
}

