/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.functest.framework;

import com.atlassian.jira.functest.framework.WebTestDescription;
import com.atlassian.jira.functest.framework.WebTestListener;
import com.atlassian.jira.util.dbc.Assertions;
import com.google.common.base.Function;
import com.google.common.base.Predicate;
import com.google.common.collect.Maps;
import com.google.common.util.concurrent.ThreadFactoryBuilder;
import java.util.Map;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JiraTestWatchDog
implements WebTestListener {
    private static final Logger log = LoggerFactory.getLogger(JiraTestWatchDog.class);
    private final ScheduledExecutorService service;
    private final Predicate<WebTestDescription> monitorPredicate;
    private final Map<WebTestDescription, ScheduledFuture<?>> runningTests = Maps.newConcurrentMap();
    private final Function<WebTestDescription, ?> timoutCallable;
    private final long timeout;
    private final long repeatMax;
    private final long repeatDelay;
    private final TimeUnit unit;

    JiraTestWatchDog(Predicate<WebTestDescription> monitorPredicate, long timeout, long repeatDelay, TimeUnit unit, long repeatMax, Function<WebTestDescription, ?> timeoutCallable, ScheduledExecutorService service) {
        this.service = Assertions.notNull("service", service);
        this.monitorPredicate = Assertions.notNull("monitorPredicate", monitorPredicate);
        this.timoutCallable = Assertions.notNull("timeoutCallable", timeoutCallable);
        this.unit = Assertions.notNull("unit", unit);
        this.timeout = timeout;
        this.repeatDelay = repeatDelay;
        this.repeatMax = repeatMax;
    }

    public JiraTestWatchDog(Predicate<WebTestDescription> monitorPredicate, long timeout, long repeatDelay, TimeUnit unit, int repeatMax, Function<WebTestDescription, ?> timeoutCallable) {
        this(monitorPredicate, timeout, repeatDelay, unit, repeatMax, timeoutCallable, JiraTestWatchDog.createDefaultExecutor());
    }

    @Override
    public void suiteStarted(WebTestDescription suiteDescription) {
    }

    @Override
    public void suiteFinished(WebTestDescription suiteDescription) {
        this.close();
    }

    @Override
    public void testError(WebTestDescription description, Throwable t) {
    }

    @Override
    public void testFailure(WebTestDescription test, Throwable t) {
    }

    @Override
    public void testFinished(WebTestDescription test) {
        ScheduledFuture<?> future = this.runningTests.remove(test);
        if (future != null) {
            future.cancel(true);
        }
    }

    @Override
    public void testStarted(final WebTestDescription test) {
        if (!this.shouldMonitor(test) || this.service.isShutdown()) {
            return;
        }
        final CountDownLatch startBarrier = new CountDownLatch(1);
        ScheduledFuture<?> future = this.service.scheduleWithFixedDelay(new Runnable(){
            private int repeat = 0;
            private boolean executing = false;

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                try {
                    startBarrier.await();
                }
                catch (InterruptedException e) {
                    log.error(String.format("Watchdog task for Test '%s' was killed. Watchdog functionality disabled for this test.", test.name()), (Throwable)e);
                    return;
                }
                1 var1_2 = this;
                synchronized (var1_2) {
                    if ((long)this.repeat < JiraTestWatchDog.this.repeatMax) {
                        ++this.repeat;
                        if (this.executing) {
                            return;
                        }
                    } else {
                        return;
                    }
                    this.executing = true;
                }
                JiraTestWatchDog.this.timoutCallable.apply((Object)test);
                var1_2 = this;
                synchronized (var1_2) {
                    this.executing = false;
                    if ((long)this.repeat >= JiraTestWatchDog.this.repeatMax) {
                        JiraTestWatchDog.this.testFinished(test);
                    }
                }
            }
        }, this.timeout, this.repeatDelay, this.unit);
        this.runningTests.put(test, future);
        startBarrier.countDown();
    }

    public void close() {
        for (ScheduledFuture<?> future : this.runningTests.values()) {
            future.cancel(true);
        }
        this.service.shutdown();
    }

    private boolean shouldMonitor(WebTestDescription test) {
        return this.monitorPredicate.apply((Object)test);
    }

    private static ScheduledExecutorService createDefaultExecutor() {
        ThreadFactory factory = new ThreadFactoryBuilder().setDaemon(true).setNameFormat("WatchDogThread-%d").build();
        return Executors.newSingleThreadScheduledExecutor(factory);
    }
}

